% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allProbs.R
\name{allProbs}
\alias{allProbs}
\title{Matrix of all probabilities}
\usage{
allProbs(data, nbStates, stepDist, angleDist, stepPar, anglePar = NULL,
  zeroInflation = FALSE, knownStates = NULL)
}
\arguments{
\item{data}{Object \code{moveData}.}

\item{nbStates}{Number of states of the HMM.}

\item{stepDist}{Name of the distribution of the step lengths.}

\item{angleDist}{Name of the distribution of the turning angles.
Set to "none" if the angle distribution should not be estimated.}

\item{stepPar}{Parameters of the step length distribution. Must be provided in a
matrix with one row for each parameter (in the order expected by the pdf of \code{stepDist}),
and one column for each state.}

\item{anglePar}{Parameters of the turning angle distribution. Must be provided in a
matrix with one row for each parameter (in the order expected by the pdf of \code{angleDist}),
and one column for each state. Default: \code{NULL} ; if the turning angles distribution
is not estimated.}

\item{zeroInflation}{\code{TRUE} if the step length distribution is inflated in zero.
Default: \code{FALSE}.}

\item{knownStates}{Vector of values of the state process which are known prior to fitting the
model (if any). Default: NULL (states are not known). This should be a vector with length the number
of rows of 'data'; each element should either be an integer (the value of the known states) or NA if
the state is not known.}
}
\value{
Matrix of all probabilities.
}
\description{
Used in functions \code{\link{viterbi}}, \code{\link{logAlpha}}, \code{\link{logBeta}}.
}
\examples{
\dontrun{
stepPar <- c(1,10,1,5,0.2,0.3)
anglePar <- c(0,pi,0.5,2)
stepDist <- "gamma"
angleDist <- "vm"
data <- simData(nbAnimals=5,nbStates=2,stepDist=stepDist,angleDist=angleDist,stepPar=stepPar,
                 anglePar=anglePar,nbCovs=2,zeroInflation=TRUE)
P <- allProbs(data=data,nbStates=2,stepDist=stepDist,angleDist=angleDist,
               stepPar=matrix(stepPar,ncol=2,byrow=TRUE),anglePar=matrix(anglePar,ncol=2,
               byrow=TRUE),zeroInflation=TRUE)
}
}

