% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{mt_exclude_finish}
\alias{mt_exclude_finish}
\title{Exclude phase without mouse movement at end of trial.}
\usage{
mt_exclude_finish(
  data,
  use = "trajectories",
  save_as = use,
  dimensions = c("xpos", "ypos"),
  timestamps = "timestamps",
  verbose = FALSE
)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{save_as}{a character string specifying where the resulting trajectory
data should be stored.}

\item{dimensions}{a character vector specifying the dimensions in the
trajectory array that contain the mouse positions.}

\item{timestamps}{a character string specifying the trajectory dimension
containing the timestamps.}

\item{verbose}{logical indicating whether function should report its
progress.}
}
\value{
A mousetrap data object (see \link{mt_example}) from which a
potential phase without mouse movement at the end of the trial was removed.
If the trajectory array was provided directly as \code{data}, only the
trajectory array will be returned.
}
\description{
Exclude a potential phase at the end of a trial where the mouse was not moved. The
corresponding samples (x- and y-positions and timestamps) in the trajectory
data will be removed.
}
\details{
\code{mt_exclude_finish} removes all samples (except the first) at the end of
the trial during which the mouse was not moved compared to its final
position. It returns only x- and y-positions as well as timestamps.

Please note that this operation may result in changes in several
mouse-tracking measures, for example, the response time (RT).
}
\examples{
mt_example <- mt_exclude_finish(mt_example,
  save_as="mod_trajectories")

}
\seealso{
\link{mt_exclude_initiation} for removing a potential initial phase
without mouse movement.
}
\author{
Pascal J. Kieslich

Dirk U. Wulff
}
