% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Oil_history.R
\docType{data}
\name{Oil_history}
\alias{Oil_history}
\title{Historical production of crude oil, worldwide 1880-2014}
\format{A data frame with 47 cases, each of which is a US state, with observations on the following variables.
\itemize{
\item{\code{year}} {the year for which production is reported}
\item{\code{mbbl}} {oil production in millions of barrels}
}}
\source{
Assembled from older information from  RH Romer (1976) "Energy: An Introduction to Physics" and more recent
data from \code{data.oecd.org}.
}
\usage{
data(Oil_history)
}
\description{
Annual production of crude oil, in millions of barrels (mbbl).
}
\examples{
model <- lm(log(mbbl) ~ year, data = Oil_history)
mod_plot(model)
}
\keyword{datasets}
