% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasetsDoc.R
\docType{data}
\name{Riders}
\alias{Riders}
\title{Volume of Users of a Massachusetts Rail Trail}
\format{
A data frame with 90 observations on the following 12 variables.
\describe{
\item{\code{date}}{date of data collection (POSIXct)}
\item{\code{day}}{a factor with levels \code{Monday}, \code{Tuesday}, \code{Wednesday},
\code{Thursday}, \code{Friday}, \code{Saturday}, and \code{Sunday}.}
\item{\code{highT}}{high temperature for the day (in degrees Fahrenheit)}
\item{\code{lowT}}{low temperature for the day (in degrees Fahrenheit)}
\item{\code{hi}}{shorter name for \code{highT}}
\item{\code{lo}}{shorter name for \code{lowT}}
\item{\code{precip}}{inches of precipitation}
\item{\code{clouds}}{measure of cloud cover (in oktas)}
\item{\code{riders}}{estimated number of trail crossings that day (number of breaks recorded)}
\item{\code{ct}}{shorter name for \code{riders}}
\item{\code{weekday}}{type of day: a factor with levels \code{N} (weekend or holiday)
\code{Y} (non-holiday weekday)}
\item{\code{wday}}{shorter name for \code{weekday}}
}
}
\source{
Pioneer Valley Planning Commission,
http://www.fvgreenway.org/pdfs/Northampton-Bikepath-Volume-Counts\%20_05_LTA.pdf
}
\usage{
data(Riders)
}
\description{
The Pioneer Valley Planning Commission (PVPC) collected data north of
Chestnut Street in Florence, MA for ninety days from April 5, 2005 to
November 15, 2005. Data collectors set up a laser sensor, with breaks in the laser beam
recording when a rail-trail user passed the data collection station.
}
\details{
There is a potential for error when two users trigger the infrared beam at exactly the same time
since the counter would only logs one of the crossings.  The collectors left the motion detector
out during the winter, but because the counter drops data when the temperature falls below 14
degrees Fahrenheit, there are no data for the coldest winter months.
}
\examples{
data(Riders)
str(Riders)

}
\references{
"Rail trails and property values: Is there an association?",
Nicholas J. Horton and Ella Hartenian (Journal of Statistics Education, 2015),
http://www.amstat.org/publications/jse/v23n2/horton.pdf
}
