% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traj_plot.R
\name{traj_plot}
\alias{traj_plot}
\title{Plots a trajectory}
\usage{
traj_plot(..., npts = 500, nt = 5)
}
\arguments{
\item{\dots}{Handles the first several objects which are, in this order
- tilde: a two sided tilde expression
- soln: optionally, a solution object such as from \code{integrateODE()}, or instead
- domain: a domain object, e.g. \code{domain(t=0:10)}}

\item{npts}{number of plotted points (default: 500)}

\item{nt}{number of tick marks to use in a trajectory plot}
}
\description{
This function handles trajectories can stem from either of two sources:
\enumerate{
\item A parametric description of a curve, such as \code{sin(t) ~ cos(t)}, along with a
domain in t.
\item The solution to an ordinary differential equation as produce by \code{integrateODE()}
}
}
\details{
The tilde expression is the critical part
}
\examples{
traj_plot(2*x + 3 ~ sin(x), domain(x=0:10))
PPdyn <- makeODE(dR ~  0.3*R - 0.03*R*F, dF ~ -0.3*F + 0.0003*R*F)
Soln <- integrateODE(PPdyn, domain(t=0:20), R=1200, F=8)
traj_plot(R(t) ~ F(t), Soln, nt=10)
traj_plot(R(t)*F(t) ~ t, Soln, nt=0)

}
