% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDist.R
\name{plotDist}
\alias{plotDist}
\title{Plots of Discrete and Continuous Distributions}
\usage{
plotDist(dist, ..., add, under = FALSE, packets = NULL, rows = NULL,
  columns = NULL, kind = c("density", "cdf", "qq", "histogram"),
  xlab = "", ylab = "", breaks = NULL, type, resolution = 5000,
  params = NULL)
}
\arguments{
\item{dist}{A string identifying the distribution.  This should work
with any distribution that has associated functions beginning
with 'd', 'p', and 'q' (e.g, 
\code{\link{dnorm}},
\code{\link{pnorm}}, and 
\code{\link{qnorm}}).  \code{dist} should match the name of the 
distribution with the initial 'd', 'p', or 'q' removed.}

\item{add}{a logical indicating whether the plot should be added to the previous lattice plot. 
If missing, it will be set to match \code{under}.}

\item{under}{a logical indicating whether adding should be done in a layer under or over the existing 
layers when \code{add = TRUE}.}

\item{packets, rows, columns}{specification of which panels will be added to when 
\code{add} is \code{TRUE}.  See \code{\link[latticeExtra]{layer}}.}

\item{kind}{one of "density", "cdf", "qq", or "histogram" (or prefix 
of any of these)}

\item{xlab, ylab}{as per other lattice functions}

\item{breaks}{a vector of break points for bins of histograms,
as in \code{\link{histogram}}}

\item{type}{passed along to various lattice graphing functions}

\item{resolution}{number of points to sample when generating the plots}

\item{params}{a list containing parameters for the distribution.  If \code{NULL} (the default), 
this list is created from elements of \code{\dots} that are either unnamed or have names among
the formals of the appropriate distribution function.  See the examples.}

\item{\dots}{other arguments passed along to lattice graphing routines}
}
\description{
Provides a simple way to generate plots of pdfs, probability mass functions,
cdfs, probability histograms, and normal-quantile plots for distributions
known to R.
}
\details{
\code{plotDist} determines whether the distribution 
	is continuous or discrete by seeing if all the sampled quantiles are 
	unique.  A discrete random variable with many possible values could 
	fool this algorithm and be considered continuous.

The plots are done referencing a data frame with variables
\code{x} and \code{y} giving points on the graph of the 
pdf, pmf, or cdf for the distribution.  This can be useful in conjuction
with the \code{groups} argument.  See the examples.
}
\examples{
plotDist('norm')
plotDist('norm', type='h')
plotDist('norm', kind='cdf')
plotDist('exp',  kind='histogram')
plotDist('binom', params=list( 25, .25))       # explicit params
plotDist('binom', 25, .25)                     # params inferred
plotDist('norm', mean=100, sd=10, kind='cdf')  # params inferred
plotDist('binom', 25, .25, xlim=c(-1,26) )     # params inferred
plotDist('binom', params=list( 25, .25), kind='cdf')
plotDist('beta', params=list( 3, 10), kind='density')
plotDist('beta', params=list( 3, 10), kind='cdf')
plotDist( "binom", params=list(35,.25), 
           groups= y < dbinom(qbinom(0.05, 35, .25), 35,.25) )
plotDist( "binom", params=list(35,.25), 
           groups= y < dbinom(qbinom(0.05, 35, .25), 35,.25), 
           kind='hist')
plotDist("norm", mean=10, sd=2, col="blue", type="h")
plotDist("norm", mean=12, sd=2, col="red", type="h", under=TRUE)
plotDist("binom", size=100, prob=.30) +
  plotDist("norm", mean=30, sd=sqrt(100 * .3 * .7))
plotDist("chisq", df=4, groups = x > 6, type="h")
if (require(mosaicData)) {
histogram( ~age|sex, data=HELPrct)
m <- mean( ~age|sex, data=HELPrct)
s <- sd(~age|sex, data=HELPrct)
plotDist( "norm", mean=m[1], sd=s[1], col="red", add=TRUE, packets=1)
plotDist( "norm", mean=m[2], sd=s[2], col="blue", under=TRUE, packets=2)
}

}
\keyword{graphics}
\keyword{stats}

