% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq.R
\name{chisq}
\alias{chisq}
\alias{chisq.default}
\alias{chisq.htest}
\alias{chisq.table}
\title{Extract Chi-squared statistic}
\usage{
chisq(x, ...)

\method{chisq}{htest}(x, ...)

\method{chisq}{table}(x, correct = FALSE, ...)

\method{chisq}{default}(x, correct = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{"htest"} a coming from a Chi-squared test,
an object of class \code{"table"}, or
the inputs to \code{\link{tally}}.}

\item{...}{additional arguments passed on to \code{tally} or \code{chisq.test}.}

\item{correct}{a logical indicating whether a continuity correction should be 
applied.}
}
\description{
Extract Chi-squared statistic
}
\examples{

if(require(mosaicData)) {
  Mites.table <- tally( ~ outcome + treatment, data=Mites )
  Mites.table 
  chisq.test(Mites.table)
  chisq(Mites.table)
  chisq(chisq.test(Mites.table))
  ## Randomization test.  Increase replications to decrease Monte Carlo error.
  do(3) * chisq( tally( ~ outcome + shuffle(treatment),  data=Mites ) )
  Mites.rand <- do(1000) * chisq( tally( ~ outcome + shuffle(treatment),  data=Mites ) )
  tally( ~(X.squared >= chisq(Mites.table)), data=Mites.rand, format="proportion")
}
  
}
\seealso{
\code{\link{stat}}
}

