% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survFitTKTD.R
\name{survFitTKTD}
\alias{survFitTKTD}
\title{Fits a TKTD for survival analysis using Bayesian inference for \code{survDataTKTD} object}
\usage{
survFitTKTD(data, n.chains = 3, quiet = FALSE)
}
\arguments{
\item{data}{An object of class \code{survData}.}

\item{n.chains}{Number of MCMC chains. The minimum required number of chains
is 2.}

\item{quiet}{If \code{FALSE}, prints logs and progress bar from JAGS.}
}
\value{
The function returns an object of class \code{survFitTKTD}, which is
a list with the following information:
\item{estim.par}{a table of the estimated parameters as medians and 95\%
credible intervals}
\item{mcmc}{an object of class \code{mcmc.list} with the posterior
distribution}
\item{warnings}{a table with warning messages}
\item{model}{a JAGS model object}
\item{parameters}{a list of parameter names used in the model}
\item{n.chains}{an integer value corresponding to the number of chains used
for the MCMC computation}
\item{n.iter}{a list of two indices indicating the beginning and the end of
monitored iterations}
\item{n.thin}{a numerical value corresponding to the thinning interval}
\item{jags.data}{a list of data passed to the JAGS model}
}
\description{
This function estimates the parameters of a TKTD
model for survival analysis using Bayesian inference. In this model,
the survival rate of individuals is modeled as a function of the chemical compound
concentration with a mechanistic description of the effects on survival over
time.
}
\examples{

# (1) Load the survival data
data(propiconazole)

# (2) Create an object of class "survData"
dataset <- survData(propiconazole)

\dontrun{
# (3) Run the survFitTKTD function
out <- survFitTKTD(dataset)

# (4) Summarize look the estimated parameters
summary(out)

# (5) Plot the fitted curve
plot(out, adddata = TRUE)

# (6) Plot the fitted curve with ggplot style and CI as spaghetti
plot(out, spaghetti = TRUE , adddata = TRUE,
     style = "ggplot")
}

}
\references{
Delignette-Muller ML, Ruiz P and Veber P (2017).
\emph{Robust fit of toxicokinetic-toxicodynamic models using prior knowledge contained in the design of survival toxicity tests.}

Bedaux, J., Kooijman, SALM (1994) Statistical analysis of toxicity tests,
based on hazard modeling, \emph{Environmental and Ecological Statistics}, 1,
303-314.
}
\keyword{estimation}
