% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.reproFitTT.R
\name{plot.reproFitTT}
\alias{plot.reproFitTT}
\title{Plotting method for \code{reproFitTT} objects}
\usage{
\method{plot}{reproFitTT}(x, xlab = "Concentration",
  ylab = "Nb of offspring per ind.day", main = NULL, fitcol = "red",
  fitlty = 1, fitlwd = 1, ci = FALSE, cicol = "pink1", cilty = 1,
  cilwd = 1, addlegend = FALSE, log.scale = FALSE, style = "generic",
  ...)
}
\arguments{
\item{x}{an object of class \code{reproFitTT}}

\item{xlab}{a title for the \eqn{x}-label}

\item{ylab}{a title for the \eqn{y}-label}

\item{main}{main title for the plot}

\item{fitcol}{color used for the fitted curve}

\item{fitlty}{line type for the fitted curve}

\item{fitlwd}{width of the fitted curve}

\item{ci}{if \code{TRUE}, draws the 95 \% credible limits of the fitted curve}

\item{cicol}{color for the 95 \% credible limits of the fitted curve}

\item{cilty}{line type for the 95 \% credible limits of the fitted curve}

\item{cilwd}{width of the 95 \% credible limits of the fitted curve}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{log.scale}{if \code{TRUE}, displays \eqn{x}-axis in log-scale}

\item{style}{graphical backend, can be \code{'generic'} or \code{'ggplot'}}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\description{
Plotting method for \code{reproFitTT} objects
}
\note{
When \code{style = "ggplot"}, the function calls package
\code{\link[ggplot2]{ggplot}} and returns an object of class \code{ggplot}.

For an example, see the paragraph on \code{\link{reproFitTT}}.
}
\keyword{plot}

