% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mytable.R
\name{mytable2}
\alias{mytable2}
\title{Produce combind table for descriptive statistics}
\usage{
mytable2(formula, data, max.ylev = 5, digits = 2, method = 1,
  show.all = FALSE)
}
\arguments{
\item{formula}{An object of class "formula". Left side of ~ must contain two grouping variables in an
additive way(e.g. sex+group~), and the right side of ~ must have
variables in an additive way.}

\item{data}{A data.frame contains data for analysis}

\item{max.ylev}{An integer indicating the maximum number of levels of grouping
variable ('y'). If a colummn have unique values less than max.ylev
it is treated as a categorical variable. Default value is 5.}

\item{digits}{An integer indicating the number of decimal places (round) or
significant digits (signif) to be used. Default value is 1.}

\item{method}{An integer indicating methods for continuous variables.
Possible values in methods are
\describe{
   \item{1}{forces analysis as normal-distributed}
   \item{2}{forces analysis as continuous non-normal}
   \item{3}{performs a Shapiro-Wilks test to decide between
           normal or non-normal}
}
Default value is 1.}

\item{show.all}{A logical value indicating whether or not all statistical
values have to be shown in table. Default value is FALSE.}
}
\value{
An object of class "cbind.mytable"
}
\description{
Produce table for descriptive statistics by two grouping variables for several variables easily.
Depending on  the nature of these variables, different descriptive statistical
methods were used(t-test, ANOVA,Kruskal-Wallis, chisq, Fisher,...)
}

