% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/procrustesFit.2.R
\name{procrustesFit.2}
\alias{procrustesFit.2}
\title{Mass Extraction of Generalized Procrustes Analysis Coordinates from Anchors}
\usage{
procrustesFit.2(x, e, makeplot = FALSE, reflect = FALSE, swap = TRUE,
  axispointscale = 0.8, sgn = c(1, -1))
}
\arguments{
\item{x}{a list containing landmark coordinate data of anchors from the specimens of interest}

\item{e}{a constant specifying the anchor of interest: ventral right(1), ventral left(2), dorsal right(3), dorsal left(4)}

\item{makeplot}{if TRUE, returns a scatter plot of the GPA-coordinates}

\item{reflect}{logical; if TRUE, x-coordinates are reflected around the x=0 axis}

\item{swap}{logical; if TRUE, the x and y-coordinates are swapped}

\item{axispointscale}{a numeric constant for controlling the font size of numeric values on the xy axes}

\item{sgn}{a numeric vector; two choices 1 and -1; defaults to c(1,-1)}
}
\value{
an array containing GPA-coordinates of the specimens of interest
}
\description{
Given a list of landmark coordinate data, this function performs Generalized Procrustes Analysis (GPA) and extracts the GPA-coordinates.
}
\details{
This function is essentially a wrapper for \code{procrustesFit} and \code{stdLM} to ease extraction of GPA-coordinates
from list data. Both require the \code{geomorph} package (Version 3.0.0).
}
\examples{
data(ligophorus_tpsdata)

vright <- procrustesFit.2(ligophorus_tpsdata$johorensis, 1,
makeplot=TRUE, reflect=FALSE, swap=TRUE, sgn=c(-1,1))

vleft <- procrustesFit.2(ligophorus_tpsdata$johorensis, 2,
makeplot=TRUE, reflect=TRUE, swap=TRUE, sgn=c(-1,1))

va <- (vright+vleft)/2

plotLM(va, "VA", pointscale=0.8, meansize=1.2, polygon.outline=TRUE,
axispointscale=0.8, c(-.6,.6),c(-.6,.6))
}
\author{
Tsung Fei Khang \email{tfkhang@um.edu.my}
}
\references{
Khang TF, Soo OYM, Tan WB, Lim LHS. (2016). Monogenean anchor morphometry: systematic value, phylogenetic signal, and evolution. PeerJ 4:e1668.

Adams DC, Otarola-Castillo E. (2013). geomorph: an R package for the collection and analysis of geometric morphometric shape data. Methods in Ecology and Evolution 4:393-399.
}
\seealso{
\code{\link{procrustesFit}}, \code{\link{stdLM}}
}

