% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monaco.R
\name{monaco-shiny}
\alias{monaco-shiny}
\alias{monacoOutput}
\alias{renderMonaco}
\title{Shiny bindings for Monaco editor}
\usage{
monacoOutput(outputId, width = "100\%", height = "400px")

renderMonaco(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{CSS measurements (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended}

\item{expr}{an expression that creates a Monaco editor with
\code{\link{monaco}}}

\item{env}{the environment in which to evaluate \code{expr}}

\item{quoted}{logical, whether \code{expr} a quoted expression}
}
\description{
Output and render functions for using Monaco editors within Shiny
applications and interactive Rmd documents.
}
\examples{
library(monaco)
library(shiny)

ui <- fluidPage(
  monacoOutput("ed", height = "400px")
)

server <- function(input, output){

  output[["ed"]] <- renderMonaco({
    monaco(
      system.file("exampleFiles", "JavaScript.js", package = "monaco")
    )
  })

}

if(interactive()){
  shinyApp(ui, server)
}


# Customizing the input range, using the 'sass' package ####

library(monaco)
library(shiny)
library(sass)

ui <- fluidPage(

  uiOutput("style"),

  titlePanel("Customized range input"),

  fluidRow(
    column(
      width = 4,
      actionButton("sass", "Compile to CSS", class = "btn-primary btn-block")
    ),
    column(
      width = 8,
      tags$input(type = "range", min = 0, max = 10, step = 0.1)
    )
  ),

  br(),

  fluidRow(
    column(
      width = 6,
      monacoOutput("scss", height = "75vh")
    ),
    column(
      width = 6,
      monacoOutput("css", height = "75vh")
    )
  )
)

server <- function(input, output){

  output[["scss"]] <- renderMonaco({
    monaco(
      system.file(
        "htmlwidgets", "customRangeInput", "customRangeInput.scss",
        package = "monaco"
      ),
      header = FALSE
    )
  })

  css <- eventReactive(input[["sass"]], {
    sass(input[["scss"]])
  })

  output[["css"]] <- renderMonaco({
    monaco(css(), language = "css", header = FALSE)
  })

  output[["style"]] <- renderUI({
    tags$head(tags$style(HTML(input[["css"]])))
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
