% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_fit_outlier.R
\name{fit_multiple_models}
\alias{fit_multiple_models}
\title{Fit Multiple Models}
\usage{
fit_multiple_models(
  A,
  z,
  response,
  alpha = 0.05,
  type = "fwd",
  q = 0.5,
  comp = NULL,
  nsim = 10000,
  ncores = 1,
  trace = TRUE,
  validate = TRUE
)
}
\arguments{
\item{A}{A character matrix or data.frame}

\item{z}{Named vector. Same names as \code{colnames(A)} but without the
class variable}

\item{response}{A character with the name of the class variable of interest}

\item{alpha}{The significance level}

\item{type}{Character ("fwd", "bwd", "tree" or "tfwd") - the type of
interaction graph to be used}

\item{q}{Penalty term in the stopping criterion when fitting the interaction
graph (\code{0} = AIC and \code{1} = BIC)}

\item{comp}{A list with character vectors. Each element in the list is a
component in the graph (using expert knowledge)}

\item{nsim}{Number of simulations}

\item{ncores}{Number of cores to use in parallelization}

\item{trace}{Logical indicating whether or not to trace the procedure}

\item{validate}{Logical. If true, it checks if \code{A} has only single
character values and converts it if not.}
}
\value{
An object of type \code{multiple_models}; a list of of \code{novely}
objects from which one
can query pvalues etc. for outlierdetection.
}
\description{
Conduct multiple novelty tests for a new observation
}
\examples{

library(dplyr)
set.seed(1)

# A patient with psoriasis
z <- unlist(derma[2, 1:10])

d <- derma[, c(names(z), "ES")] \%>\%
     filter(ES \%in\% c("chronic dermatitis", "psoriasis"))

m <- fit_multiple_models(d, z, "ES", nsim = 1000, trace = FALSE, validate = FALSE)

plot(m)
print(m)

}
\seealso{
\code{\link{fit_outlier}}, \code{\link{fit_mixed_outlier}}
}
