% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFI.R
\name{RFI}
\alias{RFI}
\title{Calculate Boyer's (2008) relief index for a surface}
\usage{
RFI(plyFile)
}
\arguments{
\item{plyFile}{An object of classes 'mesh3d' and 'shape3d'}
}
\description{
A function that calculates relief index following Boyer (2008) Relief index of
second mandibular molars is a correlate of diet among prosimian primates and
other mammals. J Hum Evol 55:1118-1137 doi: 10.1016/j.jhevol.2008.08.002
}
\details{
The function requires an object created by reading in a ply file utilizing
either the read.ply or the read.AVIZO.ply function, with calculated normals.

Relief index is calculated by the ratio of three-dimensional surface area to two
dimensional area on meshes that represent specimen surfaces and have already
been pre-smoothed in a 3D data editing program. Alignment of the point cloud
will have a large effect on patch orientation and must be done in a 3D data editing
program or {auto3dgm} prior to creating and reading in the ply file. The mesh
must be oriented such that the occlusal plane is parallel to the X- and Y-axes and
perpendicular to the Z-axis.
}

