% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ER.R
\name{ER}
\alias{ER}
\title{Robust EM-algorithm ER}
\usage{
ER(
  data,
  weights,
  alpha = 0.01,
  psi.par = c(2, 1.25),
  em.steps = 100,
  steps.output = FALSE,
  Estep.output = FALSE,
  tolerance = 1e-06
)
}
\arguments{
\item{data}{a data frame or matrix with the data.}

\item{weights}{sampling weights.}

\item{alpha}{probability for the quantile of the cut-off.}

\item{psi.par}{further parameters passed to the psi-function.}

\item{em.steps}{number of iteration steps of the EM-algorithm.}

\item{steps.output}{if \code{TRUE}, verbose output.}

\item{Estep.output}{if \code{TRUE}, estimators are output at each iteration.}

\item{tolerance}{convergence criterion (relative change).}
}
\value{
\describe{
  \item{\code{sample.size}}{Number of observations}
  \item{\code{number.of.variables}}{Number of variables}
  \item{\code{significance.level}}{alpha}
  \item{\code{computation.time}}{Elapsed computation time}
  \item{\code{good.data}}{Indices of the data in the final good subset}
  \item{\code{outliers}}{Indices of the outliers}
  \item{\code{center}}{Final estimate of the center}
  \item{\code{scatter}}{Final estimate of the covariance matrix}
  \item{\code{dist}}{Final Mahalanobis distances}
  \item{\code{rob.weights}}{Robustness weights in the final EM step}
}
}
\description{
The \code{ER} function is an implementation of the ER-algorithm
of Little and Smith (1987).
}
\details{
The M-step of the EM-algorithm uses a one-step M-estimator.
}
\examples{
data(bushfirem, bushfire.weights)
det.res <- ER(bushfirem, weights = bushfire.weights, alpha = 0.05,
steps.output = TRUE, em.steps = 100, tol = 2e-6)
PlotMD(det.res$dist, ncol(bushfirem))
}
\references{
Little, R. and P. Smith (1987). Editing and imputation for
quantitative survey data. Journal of the American Statistical Association, 82, 58-68.
}
\seealso{
\code{\link{BEM}}
}
\author{
Beat Hulliger
}
