% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasummary_df.R
\name{datasummary_df}
\alias{datasummary_df}
\title{Draw a table from a data.frame}
\usage{
datasummary_df(
  data,
  output = "default",
  fmt = 2,
  align = NULL,
  hrule = NULL,
  title = NULL,
  notes = NULL,
  add_rows = NULL,
  add_columns = NULL,
  ...
)
}
\arguments{
\item{data}{A data.frame (or tibble)}

\item{output}{filename or object type (character string)
\itemize{
\item Supported filename extensions: .html, .tex, .md, .txt, .png, .jpg.
\item Supported object types: "default", "html", "markdown", "latex", "latex_tabular", "data.frame", "modelsummary_list", "gt", "kableExtra", "huxtable", "flextable", "jupyter".
\item To change the default output format, type \code{options(modelsummary_default = "latex")}, where \code{latex} can be any of the valid object types listed above.
\item Warning: users should not supply a file name to the \code{output} argument if they intend to customize the table with external packages.
\item See the 'Details' section below for more information.
}}

\item{fmt}{determines how to format numeric values
\itemize{
\item integer: the number of digits to keep after the period \code{format(round(x, fmt), nsmall=fmt)}
\item character: passed to the \code{sprintf} function (e.g., '\%.3f' keeps 3 digits with trailing zero). See \code{?sprintf}
\item function: returns a formatted character string.
}}

\item{align}{A character string of length equal to the number of columns in
the table.  "lcr" means that the first column will be left-aligned, the 2nd
column center-aligned, and the 3rd column right-aligned.}

\item{hrule}{position of horizontal rules (integer vector)}

\item{title}{string}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{add_rows}{a data.frame (or tibble) with the same number of columns as
your main table. By default, rows are appended to the bottom of the table.
You can define a "position" attribute of integers to set the row positions.
See Examples section below.}

\item{add_columns}{a data.frame (or tibble) with the same number of rows as
your main table.}

\item{...}{all other arguments are passed through to the extractor and
table-making functions. This allows users to pass arguments directly to
\code{modelsummary} in order to affect the behavior of other functions behind
the scenes. Examples include:
\itemize{
\item \code{broom::tidy(exponentiate=TRUE)} to exponentiate logistic regression
\item \code{kableExtra::kbl(escape=FALSE)} to avoid escaping math characters in \code{kableExtra} tables.
\item \code{performance::model_performance(metrics="RMSE")} to select goodness-of-fit statistics to extract using the \code{performance} package (must have set \code{options(modelsummary_get="easystats")} first).
}}
}
\description{
Draw a table from a data.frame
}
