% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{HV}
\alias{HV}
\title{statistic of the Henze-Visagie test}
\usage{
HV(data, a = 5)
}
\arguments{
\item{data}{a n x d numeric matrix of data values.}

\item{a}{numeric number greater than 1 (tuning parameter).}
}
\value{
The value of the test statistic.
}
\description{
Computes the test statistic of the Henze-Visagie test.
}
\details{
This functions evaluates the teststatistic with the given data and the specified tuning parameter \code{a}.
Each row of the data Matrix contains one of the n (multivariate) sample with dimension d. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the function returns an error.

Note that \code{a=Inf} returns the limiting test statistic with value \code{2*\link{MSkew} + \link{MRSSkew}}.
}
\examples{
HV(MASS::mvrnorm(50,c(0,1),diag(1,2)),a=5)
HV(MASS::mvrnorm(50,c(0,1),diag(1,2)),a=Inf)

}
\references{
Henze, N., Visagie, J. (2019) "Testing for normality in any dimension based on a partial differential equation involving the moment generating function", to appear in Ann. Inst. Stat. Math., \href{https://doi.org/10.1007/s10463-019-00720-8}{DOI}
}
