% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{BHEP}
\alias{BHEP}
\title{Statistic of the BHEP-test}
\usage{
BHEP(data, a = 1)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{a}{positive numeric number (tuning parameter).}
}
\value{
value of the test statistic.
}
\description{
This function returns the value of the statistic of the Baringhaus-Henze-Epps-Pulley (BHEP) test as in Henze and Wagner (1997).
}
\details{
The test statistic is \deqn{BHEP_{n,\beta}=\frac{1}{n} \sum_{j,k=1}^n \exp\left(-\frac{\beta^2\|Y_{n,j}-Y_{n,k}\|^2}{2}\right)- \frac{2}{(1+\beta^2)^{d/2}} \sum_{j=1}^n \exp\left(- \frac{\beta^2\|Y_{n,j}\|^2}{2(1+\beta^2)} \right) + \frac{n}{(1+2\beta^2)^{d/2}}.}
Here, \eqn{Y_{n,j}=S_n^{-1/2}(X_j-\overline{X}_n)}, \eqn{j=1,\ldots,n}, are the scaled residuals, \eqn{\overline{X}_n} is the sample mean and \eqn{S_n} is the sample covariance matrix of the random vectors \eqn{X_1,\ldots,X_n}. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the function returns an error.
}
\examples{
BHEP(MASS::mvrnorm(50,c(0,1),diag(1,2)))

}
\references{
Henze, N., and Wagner, T. (1997), A new approach to the class of BHEP tests for multivariate normality, J. Multiv. Anal., 62:1–23, \href{https://doi.org/10.1006/jmva.1997.1684}{DOI}

Epps T.W., Pulley L.B. (1983), A test for normality based on the empirical characteristic function, Biometrika, 70:723-726, \href{https://doi.org/10.1093/biomet/70.3.723}{DOI}
}
