% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerInterMBO.R
\name{OptimizerInterMBO}
\alias{OptimizerInterMBO}
\alias{mlr_optimizers_intermbo}
\alias{mlr_tuners_intermbo}
\alias{TunerInterMBO}
\title{Tuner and Optimizer using mlrMBO}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3tuning:Tuner]{mlr3tuning::Tuner} or \link[bbotk:Optimizer]{bbotk::Optimizer}.
}
\description{
mlrMBO tuning object.

mlrMBO must not be loaded directly into R when using mlr3, for various reasons.
TunerInterMBO and OptimizerInterMBO take care that this does not happen.

To optimize an objective (using the \code{bbotk} package), use the \code{OptimizerInterMBO} object,
ideally obtained through the \code{\link[bbotk:opt]{bbotk::opt()}} function: \code{opt("intermbo")}.

To tune a machine learning method represented by a \link[mlr3:Learner]{mlr3::Learner} object,
use the \code{TunerInterMBO} obtained ideally through \code{\link[mlr3tuning:tnr]{mlr3tuning::tnr()}}: \code{tnr("intermbo")}.

The \code{\link[paradox:ParamSet]{ParamSet}} of the optimizer / tuner reflects the possible configuration
options of mlrMBO. The control parameters map directly to the arguments of
\code{\link[mlrMBO:makeMBOControl]{mlrMBO::makeMBOControl()}}, \code{\link[mlrMBO:setMBOControlInfill]{mlrMBO::setMBOControlInfill()}}, \code{\link[mlrMBO:setMBOControlMultiObj]{mlrMBO::setMBOControlMultiObj()}},
\code{\link[mlrMBO:setMBOControlMultiPoint]{mlrMBO::setMBOControlMultiPoint()}}, and \code{\link[mlrMBO:setMBOControlTermination]{mlrMBO::setMBOControlTermination()}}.
}
\examples{
library("paradox")
library("bbotk")

# silly example function: minimize x^2 for -1 < x < 1
domain <- ParamSet$new(list(ParamDbl$new("x", lower = -1, upper = 1)))
codomain <- ParamSet$new(list(ParamDbl$new("y", tags = "minimize")))
objective <- ObjectiveRFun$new(function(xs) list(y = xs$x^2), domain, codomain)

# initialize instance
instance <- OptimInstanceSingleCrit$new(objective, domain, trm("evals", n_evals = 6))

# use intermbo optimizer
optser <- opt("intermbo")

# optimizer has hyperparameters from mlrMBO
optser$param_set$values$final.method <- "best.predicted"

# optimization happens here.
optser$optimize(instance)

instance$result
}
