% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPO_applyFun.R
\name{cpoApplyFunRegrTarget}
\alias{cpoApplyFunRegrTarget}
\title{Transform a Regression Target Variable}
\usage{
cpoApplyFunRegrTarget(
  trafo,
  invert.response = NULL,
  invert.se = NULL,
  param = NULL,
  vectorize = TRUE,
  gauss.points = 23,
  id,
  export = "export.default",
  affect.type = NULL,
  affect.index = integer(0),
  affect.names = character(0),
  affect.pattern = NULL,
  affect.invert = FALSE,
  affect.pattern.ignore.case = FALSE,
  affect.pattern.perl = FALSE,
  affect.pattern.fixed = FALSE
)
}
\arguments{
\item{trafo}{[\code{function}]\cr
  A function transforming the target column. If \code{vectorize} is \code{TRUE},
  the argument is a vector of the whole column, \code{trafo} must vectorize over it
  and return a vector of the same length; otherwise, the function gets called once
  for every data item, and both the function argument and the return value
  must have length 1.

  The function must take one or two arguments. If it takes two arguments, the second argument
  will be \code{param}.}

\item{invert.response}{[\code{function}]\cr
  If a model is trained on data that was transformed by \code{trafo}, this function
  should invert a prediction made by this model back to the space of the original data.
  In most cases, this will be the inverse of \code{trafo}, so that \code{invert.response(trafo(x)) == x}.

  Similarly to \code{trafo}, this function takes / produces single elements or the whole
  column, depending on \code{vectorize}. The return value should be a \code{numeric}
  in both cases.

  This can also be \code{NULL}, in which case using this \code{\link{CPO}} for
  \code{\link{invert}} with \code{predict.type = "response"} is not possible.

  Default is \code{NULL}.}

\item{invert.se}{[\code{function}]\cr
  Similarly to \code{invert.response}, this is a function that inverts a \code{"se"}
  prediction made after training on \code{trafo}'d data. This function should take
  at least two arguments, \code{mean} and \code{se}, and return a numeric vector of length
  2 if \code{vectorize} is \code{FALSE}, or a \code{data.frame} or \code{matrix} with
  two numeric columns if \code{vectorize} is \code{TRUE}. The function may also take a third
  argument, which will be set to \code{param}.

  \code{invert.se} may also be \code{NULL}, in which case \dQuote{se} inversion is done
  by numeric integration using Gauss-Hermite quadrature.

  Default is \code{NULL}.}

\item{param}{[any]\cr
Optional argument to be given to \code{trafo} and / or \code{invert}. If both of
them only take one argument, this is ignored. Default is \code{NULL}.}

\item{vectorize}{[\code{logical(1)}]\cr
Whether to call \code{trafo}, \code{invert.response} and \code{invert.se} once
with the whole data column (or response \emph{and} se column if \code{predict.type == "se"}),
or once for each element. If the functions vectorize, it is recommended to have this
set to \code{TRUE} for better performance. Default is \code{TRUE}.}

\item{gauss.points}{[\code{numeric(1)}]\cr
Number of points at which to evaluate \code{invert.response} for Gauss-Hermite quadrature integration.
Only used if \code{invert.se} is \code{NULL}. Default is \code{23}.}

\item{id}{[\code{character(1)}]\cr
id to use as prefix for the CPO's hyperparameters. this
must be used to avoid name clashes when composing two
CPOs of the same type, or with learners or other CPOS
with hyperparameters with clashing names.}

\item{export}{[\code{character}]\cr
Either a character vector indicating the parameters to
export as hyperparameters, or one of the special values
\dQuote{export.all} (export all parameters),
\dQuote{export.default} (export all parameters that are exported by default),
\dQuote{export.set} (export all parameters that were set during construction),
\dQuote{export.default.set} (export the intersection of the \dQuote{default} and \dQuote{set} parameters),
\dQuote{export.unset} (export all parameters that were \emph{not} set during construction) or
\dQuote{export.default.unset} (export the intersection of the \dQuote{default} and \dQuote{unset} parameters).
Default is \dQuote{export.default}.}

\item{affect.type}{[\code{character} | \code{NULL}]\cr
Type of columns to affect. A subset of \dQuote{numeric}, \dQuote{factor}, \dQuote{ordered}, \dQuote{other}, or \code{NULL}
to not match by column type. Default is \code{NULL}.}

\item{affect.index}{[\code{numeric}]\cr
Indices of feature columns to affect. The order of indices given is respected. Target column indices are not counted
(since target columns are always included). Default is \code{integer(0)}.}

\item{affect.names}{[\code{character}]\cr
Feature names of feature columns to affect. The order of names given is respected. Default is \code{character(0)}.}

\item{affect.pattern}{[\code{character(1)} | \code{NULL}]\cr
\code{\link[base]{grep}} pattern to match feature names by. Default is \code{NULL} (no pattern matching)}

\item{affect.invert}{[\code{logical(1)}]\cr
Whether to affect all features \emph{not} matched by other \code{affect.*} parameters.}

\item{affect.pattern.ignore.case}{[\code{logical(1)}]\cr
Ignore case when matching features with \code{affect.pattern}; see \code{\link[base]{grep}}. Default is \code{FALSE}.}

\item{affect.pattern.perl}{[\code{logical(1)}]\cr
Use Perl-style regular expressions for \code{affect.pattern}; see \code{\link[base]{grep}}. Default is \code{FALSE}.}

\item{affect.pattern.fixed}{[\code{logical(1)}]\cr
Use fixed matching instead of regular expressions for \code{affect.pattern}; see \code{\link[base]{grep}}. Default is \code{FALSE}.}
}
\value{
[\code{\link{CPO}}].
}
\description{
This is a \code{\link{CPOConstructor}} to be used to create a
\code{\link{CPO}}. It is called like any R function and returns
the created \code{\link{CPO}}.

Apply a given function to the target column of a regression \code{\link{Task}}.
}
\section{Details}{

  When both \code{mean} and \code{se} prediction is available, it may be possible to
  make more accurate mean inversion than for the \code{response} \code{predict.type},
  using integrals or approximations like the \emph{delta method}. In such cases it may be
  advisable to prepend this \code{\link{CPO}} with the \code{\link{cpoResponseFromSE}}
  \code{\link{CPO}}.

  Note when \code{trafo} or \code{invert.response} take more than one argument, the
  second argument will be set to the value of \code{param}. This may lead to unexpected
  results when using functions with rarely used parameters, e.g. \code{\link[base:Log]{log}}.
  In these cases, it may be necessary to wrap the function:
  \code{trafo = function(x) log(x)}.
}

\section{General CPO info}{

This function creates a CPO object, which can be applied to
\code{\link{Task}}s, \code{data.frame}s, \code{link{Learner}}s
and other CPO objects using the \code{\link{\%>>\%}} operator.

The parameters of this object can be changed after creation
using the function \code{\link{setHyperPars}}. The other
hyper-parameter manipulating functins, \code{\link{getHyperPars}}
and \code{\link{getParamSet}} similarly work as one expects.

If the \dQuote{id} parameter is given, the hyperparameters
will have this id as aprefix; this will, however, not change
the parameters of the creator function.
}

\section{Calling a \code{\link{CPOConstructor}}}{

CPO constructor functions are called with optional values of parameters, and additional \dQuote{special} optional values.
The special optional values are the \code{id} parameter, and the \code{affect.*} parameters. The \code{affect.*} parameters
enable the user to control which subset of a given dataset is affected. If no \code{affect.*} parameters are given, all
data features are affected by default.
}

\seealso{
Other CPOs: 
\code{\link{cpoApplyFun}()},
\code{\link{cpoAsNumeric}()},
\code{\link{cpoCache}()},
\code{\link{cpoCbind}()},
\code{\link{cpoCollapseFact}()},
\code{\link{cpoDropConstants}()},
\code{\link{cpoDropMostlyConstants}()},
\code{\link{cpoDummyEncode}()},
\code{\link{cpoFilterAnova}()},
\code{\link{cpoFilterCarscore}()},
\code{\link{cpoFilterChiSquared}()},
\code{\link{cpoFilterFeatures}()},
\code{\link{cpoFilterGainRatio}()},
\code{\link{cpoFilterInformationGain}()},
\code{\link{cpoFilterKruskal}()},
\code{\link{cpoFilterLinearCorrelation}()},
\code{\link{cpoFilterMrmr}()},
\code{\link{cpoFilterOneR}()},
\code{\link{cpoFilterPermutationImportance}()},
\code{\link{cpoFilterRankCorrelation}()},
\code{\link{cpoFilterRelief}()},
\code{\link{cpoFilterRfCImportance}()},
\code{\link{cpoFilterRfImportance}()},
\code{\link{cpoFilterRfSRCImportance}()},
\code{\link{cpoFilterRfSRCMinDepth}()},
\code{\link{cpoFilterSymmetricalUncertainty}()},
\code{\link{cpoFilterUnivariate}()},
\code{\link{cpoFilterVariance}()},
\code{\link{cpoFixFactors}()},
\code{\link{cpoIca}()},
\code{\link{cpoImpactEncodeClassif}()},
\code{\link{cpoImpactEncodeRegr}()},
\code{\link{cpoImputeConstant}()},
\code{\link{cpoImputeHist}()},
\code{\link{cpoImputeLearner}()},
\code{\link{cpoImputeMax}()},
\code{\link{cpoImputeMean}()},
\code{\link{cpoImputeMedian}()},
\code{\link{cpoImputeMin}()},
\code{\link{cpoImputeMode}()},
\code{\link{cpoImputeNormal}()},
\code{\link{cpoImputeUniform}()},
\code{\link{cpoImpute}()},
\code{\link{cpoLogTrafoRegr}()},
\code{\link{cpoMakeCols}()},
\code{\link{cpoMissingIndicators}()},
\code{\link{cpoModelMatrix}()},
\code{\link{cpoOversample}()},
\code{\link{cpoPca}()},
\code{\link{cpoProbEncode}()},
\code{\link{cpoQuantileBinNumerics}()},
\code{\link{cpoRegrResiduals}()},
\code{\link{cpoResponseFromSE}()},
\code{\link{cpoSample}()},
\code{\link{cpoScaleMaxAbs}()},
\code{\link{cpoScaleRange}()},
\code{\link{cpoScale}()},
\code{\link{cpoSelect}()},
\code{\link{cpoSmote}()},
\code{\link{cpoSpatialSign}()},
\code{\link{cpoTransformParams}()},
\code{\link{cpoWrap}()},
\code{\link{makeCPOCase}()},
\code{\link{makeCPOMultiplex}()}
}
\concept{CPOs}
