% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionClust.R
\name{autoplot.PredictionClust}
\alias{autoplot.PredictionClust}
\title{Plots for Cluster Predictions}
\usage{
\method{autoplot}{PredictionClust}(
  object,
  task,
  row_ids = NULL,
  type = "scatter",
  theme = theme_minimal(),
  ...
)
}
\arguments{
\item{object}{(\link[mlr3cluster:PredictionClust]{mlr3cluster::PredictionClust}).}

\item{task}{(\link[mlr3cluster:TaskClust]{mlr3cluster::TaskClust}).}

\item{row_ids}{(\code{integer()})
Row ids to subset task data to ensure that only the data used to make predictions are shown in plots.}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link[mlr3cluster:PredictionClust]{mlr3cluster::PredictionClust}.
The argument \code{type} controls what kind of plot is drawn.
Possible choices are:
\itemize{
\item \code{"scatter"} (default): scatterplot with correlation values and colored cluster assignments.
\item \code{"sil"}: Silhouette plot with mean silhouette value as the reference line.
Requires package \CRANpkg{ggfortify}.
\item \code{"pca"}: Perform PCA on data and color code cluster assignments.
Inspired by and uses \link[ggfortify:autoplot.kmeans]{ggfortify::autoplot.kmeans}.
}
}
\examples{
if (requireNamespace("mlr3")) {
  library(mlr3)
  library(mlr3cluster)
  library(mlr3viz)

  task = tsk("usarrests")
  learner = lrn("clust.kmeans", centers = 3)
  object = learner$train(task)$predict(task)

  head(fortify(object))
  autoplot(object, task)
}
}
\references{
Tang Y, Horikoshi M, Li W (2016).
\dQuote{ggfortify: Unified Interface to Visualize Statistical Result of Popular R Packages.}
\emph{The R Journal}, \bold{8}(2), 474--485.
\doi{10.32614/RJ-2016-060}.
}
