% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionClust.R
\name{autoplot.PredictionClust}
\alias{autoplot.PredictionClust}
\title{Plot for PredictionClust}
\usage{
\method{autoplot}{PredictionClust}(object, task, row_ids = NULL, type = "scatter", ...)
}
\arguments{
\item{object}{(\link[mlr3cluster:PredictionClust]{mlr3cluster::PredictionClust}).}

\item{task}{(\link[mlr3cluster:TaskClust]{mlr3cluster::TaskClust}).}

\item{row_ids}{row ids to subset task data to ensure that
only the data used to make predictions are shown in plots.}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{...}{(\code{any}):
Additional arguments, passed down to the respective \code{geom}.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[mlr3cluster:PredictionClust]{mlr3cluster::PredictionClust}, depending on argument \code{type}:
\itemize{
\item \code{"scatter"} (default): scatterplot with correlation values
and colored cluster assignments.
\item \code{"sil"}: Silhouette plot with mean silhouette value as
a reference line.
\item \code{"pca"}: Perform PCA on data and color code cluster
assignments. Inspired by and uses \link[ggfortify:autoplot.kmeans]{ggfortify::autoplot.kmeans}.
}
}
\examples{
library(mlr3)
library(mlr3cluster)
library(mlr3viz)

task = tsk("usarrests")
learner = lrn("clust.kmeans", centers = 3)
object = learner$train(task)$predict(task)

head(fortify(object))
autoplot(object, task)
}
