% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClassifCVGlmnet.R,
%   R/LearnerClassifGlmnet.R, R/LearnerRegrCVGlmnet.R, R/LearnerRegrGlmnet.R
\name{autoplot.LearnerClassifCVGlmnet}
\alias{autoplot.LearnerClassifCVGlmnet}
\alias{autoplot.LearnerClassifGlmnet}
\alias{autoplot.LearnerRegrCVGlmnet}
\alias{autoplot.LearnerRegrGlmnet}
\title{Plots for GLMNet Learners}
\usage{
\method{autoplot}{LearnerClassifCVGlmnet}(
  object,
  type = "prediction",
  task = NULL,
  grid_points = 100L,
  expand_range = 0,
  theme = theme_minimal(),
  ...
)

\method{autoplot}{LearnerClassifGlmnet}(
  object,
  type = "prediction",
  task = NULL,
  grid_points = 100L,
  expand_range = 0,
  theme = theme_minimal(),
  ...
)

\method{autoplot}{LearnerRegrCVGlmnet}(
  object,
  type = "prediction",
  task = NULL,
  grid_points = 100L,
  expand_range = 0,
  theme = theme_minimal(),
  ...
)

\method{autoplot}{LearnerRegrGlmnet}(
  object,
  type = "prediction",
  task = NULL,
  grid_points = 100L,
  expand_range = 0,
  theme = theme_minimal(),
  ...
)
}
\arguments{
\item{object}{(\link[mlr3learners:mlr_learners_classif.glmnet]{mlr3learners::LearnerClassifGlmnet} | \link[mlr3learners:mlr_learners_regr.glmnet]{mlr3learners::LearnerRegrGlmnet} | \link[mlr3learners:mlr_learners_regr.cv_glmnet]{mlr3learners::LearnerRegrCVGlmnet} | \link[mlr3learners:mlr_learners_regr.cv_glmnet]{mlr3learners::LearnerRegrCVGlmnet}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{task}{(\link[mlr3:Task]{mlr3::Task})\cr
Train task.}

\item{grid_points}{(integer(1))\cr
Number of grid points per feature dimension.}

\item{expand_range}{(numeric(1))\cr
Expand the range of the grid.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link[mlr3learners:mlr_learners_classif.glmnet]{mlr3learners::LearnerClassifGlmnet}.
The argument \code{type} controls what kind of plot is drawn.
Possible choices are:
\itemize{
\item \code{"prediction"} (default): Decision boundary of the learner and the true class labels.
\item \code{"ggfortify"}: Visualizes the model using the package \CRANpkg{ggfortify}.
}
}
\examples{
\dontrun{
library(mlr3)
library(mlr3viz)
library(mlr3learners)

# classification
task = tsk("sonar")
learner = lrn("classif.glmnet")
learner$train(task)
autoplot(learner, type = "ggfortify")

# regression
task = tsk("mtcars")
learner = lrn("regr.glmnet")
learner$train(task)
autoplot(learner, type = "ggfortify")
}
}
\references{
Tang Y, Horikoshi M, Li W (2016).
\dQuote{ggfortify: Unified Interface to Visualize Statistical Result of Popular R Packages.}
\emph{The R Journal}, \bold{8}(2), 474--485.
\doi{10.32614/RJ-2016-060}.
}
