% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning_spaces_rbv2.R
\name{tuning_spaces_rbv2}
\alias{tuning_spaces_rbv2}
\alias{classif.ranger.rbv2}
\alias{classif.rpart.rbv2}
\alias{classif.svm.rbv2}
\alias{classif.xgboost.rbv2}
\alias{regr.ranger.rbv2}
\alias{regr.rpart.rbv2}
\alias{regr.svm.rbv2}
\alias{regr.xgboost.rbv2}
\title{RandomBot Tuning Spaces}
\source{
Kuehn D, Probst P, Thomas J, Bischl B (2018).
\dQuote{Automatic Exploration of Machine Learning Experiments on OpenML.}
1806.10961, \url{https://arxiv.org/abs/1806.10961}.
}
\description{
Tuning spaces from the Kuehn (2018) article.
}
\section{glmnet tuning space}{

\itemize{
\item alpha \eqn{[0, 1]}{[0, 1]}
\item s \eqn{[1e-04, 1000]}{[1e-04, 1000]}
}
}

\section{kknn tuning space}{

\itemize{
\item k \eqn{[1, 30]}{[1, 30]}
}
}

\section{ranger tuning space}{

\itemize{
\item num.trees \eqn{[1, 2000]}{[1, 2000]}
\item replace [TRUE,FALSE]
\item sample.fraction \eqn{[0.1, 1]}{[0.1, 1]}
\item mtry.ratio \eqn{[0, 1]}{[0, 1]}
\item respect.unordered.factors [\dQuote{ignore}, \dQuote{order}, \dQuote{partition}]
\item min.node.size \eqn{[1, 100]}{[1, 100]}
\item splitrule [\dQuote{gini}, \dQuote{extratrees}]
\item num.random.splits \eqn{[1, 100]}{[1, 100]}
}

\code{mtry.power} is replaced by \code{mtry.ratio}.
}

\section{rpart tuning space}{

\itemize{
\item cp \eqn{[1e-04, 1]}{[1e-04, 1]}
\item maxdepth \eqn{[1, 30]}{[1, 30]}
\item minbucket \eqn{[1, 100]}{[1, 100]}
\item minsplit \eqn{[1, 100]}{[1, 100]}
}
}

\section{svm tuning space}{

\itemize{
\item kernel [\dQuote{linear}, \dQuote{polynomial}, \dQuote{radial}]
\item cost \eqn{[1e-04, 1000]}{[1e-04, 1000]}
\item gamma \eqn{[1e-04, 1000]}{[1e-04, 1000]}
\item tolerance \eqn{[1e-04, 2]}{[1e-04, 2]}
\item degree \eqn{[2, 5]}{[2, 5]}
}
}

\section{xgboost tuning space}{

\itemize{
\item booster [\dQuote{gblinear}, \dQuote{gbtree}, \dQuote{dart}]
\item nrounds \eqn{[2, 8]}{[2, 8]}
\item eta \eqn{[1e-04, 1]}{[1e-04, 1]}
\item gamma \eqn{[1e-05, 7]}{[1e-05, 7]}
\item lambda \eqn{[1e-04, 1000]}{[1e-04, 1000]}
\item alpha \eqn{[1e-04, 1000]}{[1e-04, 1000]}
\item subsample \eqn{[0.1, 1]}{[0.1, 1]}
\item max_depth \eqn{[1, 15]}{[1, 15]}
\item min_child_weight \eqn{[1, 100]}{[1, 100]}
\item colsample_bytree \eqn{[0.01, 1]}{[0.01, 1]}
\item colsample_bylevel \eqn{[0.01, 1]}{[0.01, 1]}
\item rate_drop \eqn{[0, 1]}{[0, 1]}
\item skip_drop \eqn{[0, 1]}{[0, 1]}
}
}

