% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TuningSpace.R
\name{TuningSpace}
\alias{TuningSpace}
\title{Tuning Spaces}
\description{
This is the abstract base class for tuning spaces which define a search space
for hyperparameter tuning.

\code{TuningSpace} objects store a list of \link[paradox:to_tune]{paradox::TuneToken} and additional
meta information. These tokens can be assigned to the \verb{$values} slot of
a learner's \link[paradox:ParamSet]{paradox::ParamSet}.
}
\examples{
library(mlr3tuning)

# get default tuning space of rpart learner
tuning_space = mlr_tuning_spaces$get("classif.rpart.default")

# get learner and set tuning space
learner = lrn("classif.rpart")
learner$param_set$values = tuning_space$values

# tune learner
instance = tune(
 method = "random_search",
 task = tsk("pima"),
 learner = learner,
 resampling = rsmp ("holdout"),
 measure = msr("classif.ce"),
 term_evals = 10)

instance$result
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{(\code{character(1)}).}

\item{\code{values}}{(\code{list()}).}

\item{\code{tags}}{(\code{character()}).}

\item{\code{package}}{(\code{character()}).}

\item{\code{learner}}{(\code{character(1)}).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TuningSpace$new()}}
\item \href{#method-get_learner}{\code{TuningSpace$get_learner()}}
\item \href{#method-format}{\code{TuningSpace$format()}}
\item \href{#method-print}{\code{TuningSpace$print()}}
\item \href{#method-clone}{\code{TuningSpace$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TuningSpace$new(id, values, tags, learner, package = character())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{\code{values}}{(\code{list()})\cr
List of \link[paradox:to_tune]{paradox::TuneToken} and parameter values.}

\item{\code{tags}}{(\code{character()})\cr
Tags to group and filter tuning spaces.}

\item{\code{learner}}{(\code{character(1)})\cr
\link[mlr3:Learner]{mlr3::Learner} identifier in \link[mlr3:mlr_learners]{mlr3::mlr_learners}.}

\item{\code{package}}{(\code{character()})\cr
Packages which provide the \link{Learner}, e.g. \CRANpkg{mlr3learners} for the learner
\link[mlr3learners:mlr_learners_classif.ranger]{mlr3learners::LearnerClassifRanger} which interfaces the \CRANpkg{ranger} package.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_learner"></a>}}
\if{latex}{\out{\hypertarget{method-get_learner}{}}}
\subsection{Method \code{get_learner()}}{
Returns a learner with \link{TuneToken} set in parameter set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TuningSpace$get_learner(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(named ‘list()’)\cr
Passed to \code{mlr3::lrn()}. Named arguments passed to the constructor, to
be set as parameters in the \link[paradox:ParamSet]{paradox::ParamSet}, or to be set as public
field. See \code{mlr3misc::dictionary_sugar_get()} for more details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[mlr3:Learner]{mlr3::Learner}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TuningSpace$format(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TuningSpace$print(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TuningSpace$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
