% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvSongTPR.R
\name{MeasureSurvSongTPR}
\alias{MeasureSurvSongTPR}
\alias{mlr_measures_surv.songTPR}
\title{Song and Zhou's TPR Survival Measure}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \code{MeasureSurvAUC}/\link{MeasureSurv}.}
\description{


Calls \code{\link[survAUC:sens.sh]{survAUC::sens.sh()}}.

Assumes Cox PH model specification.

\code{times} and \code{lp_thresh} are arbitrarily set to \code{0} to prevent crashing, these should be further
specified.
}
\details{
All measures implemented from \CRANpkg{survAUC} should be used with care, we are aware
of problems in implementation that sometimes cause fatal errors in R. In future updates these
measures will all be re-written and implemented directly in \code{mlr3proba}.
}
\section{Construction}{
\preformatted{MeasureSurvSongTPR$new(times = 0, lp_thresh = 0, type = c("incident","cumulative"))
mlr_measures$get("surv.songTPR")
msr("surv.songTPR")
}
\itemize{
\item \code{times} :: \code{vector()} \cr If \code{integrate == TRUE} then a vector of time-points over which to integrate the score. If \code{integrate == FALSE} then a single time point at which to return the score. \cr
\item \code{lp_thresh} :: \code{numeric(1)} \cr Determines where to threshold the linear predictor for calculating the TPR/TNR. \cr
\item \code{type} :: \code{character(1)} \cr Determines the type of score, one of: \code{'cumulative'}, \code{'incident'}. Default \code{'incident'}. \cr
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{lp}
}
}

\section{Fields}{

See \link{MeasureSurv}, as well as all variables passed to the constructor.
}

\references{
Song, X. and X.-H. Zhou (2008). \cr
A semiparametric approach for the covariate specific ROC curve with survival outcome. \cr
Statistica Sinica 18, 947–965.
}
\seealso{
Other survival measures: 
\code{\link{MeasureSurvBeggC}},
\code{\link{MeasureSurvChamblessAUC}},
\code{\link{MeasureSurvGonenC}},
\code{\link{MeasureSurvGrafSE}},
\code{\link{MeasureSurvGraf}},
\code{\link{MeasureSurvHarrellC}},
\code{\link{MeasureSurvHungAUC}},
\code{\link{MeasureSurvIntLoglossSE}},
\code{\link{MeasureSurvIntLogloss}},
\code{\link{MeasureSurvLoglossSE}},
\code{\link{MeasureSurvLogloss}},
\code{\link{MeasureSurvNagelkR2}},
\code{\link{MeasureSurvOQuigleyR2}},
\code{\link{MeasureSurvSongAUC}},
\code{\link{MeasureSurvSongTNR}},
\code{\link{MeasureSurvUnoAUC}},
\code{\link{MeasureSurvUnoC}},
\code{\link{MeasureSurvUnoTNR}},
\code{\link{MeasureSurvUnoTPR}},
\code{\link{MeasureSurvXuR2}}

Other AUC survival measures: 
\code{\link{MeasureSurvChamblessAUC}},
\code{\link{MeasureSurvHungAUC}},
\code{\link{MeasureSurvSongAUC}},
\code{\link{MeasureSurvSongTNR}},
\code{\link{MeasureSurvUnoAUC}},
\code{\link{MeasureSurvUnoTNR}},
\code{\link{MeasureSurvUnoTPR}}
}
\concept{AUC survival measures}
\concept{survival measures}
