% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{oml_sugar}
\alias{oml_sugar}
\alias{odt}
\alias{otsk}
\alias{oflw}
\alias{orn}
\alias{ocl}
\title{Syntactic Sugar for Object Construction}
\usage{
odt(
  id,
  cache = cache_default(),
  parquet = parquet_default(),
  test_server = test_server_default()
)

otsk(
  id,
  cache = cache_default(),
  parquet = parquet_default(),
  test_server = test_server_default()
)

oflw(id, cache = cache_default(), test_server = test_server_default())

orn(
  id,
  cache = cache_default(),
  parquet = parquet_default(),
  test_server = test_server_default()
)

ocl(
  id,
  cache = cache_default(),
  parquet = parquet_default(),
  test_server = test_server_default()
)
}
\arguments{
\item{id}{(\code{integer(1)})\cr
OpenML id for the object.}

\item{cache}{(\code{logical(1)} | \code{character(1)})\cr
See field \code{cache} for an explanation of possible values.
Defaults to value of option \code{"mlr3oml.cache"}, or \code{FALSE} if not set.}

\item{parquet}{(\code{logical(1)})\cr
Whether to use parquet instead of arff.
If parquet is not available, it will fall back to arff.
Defaults to value of option \code{"mlr3oml.parquet"} or \code{FALSE} if not set.}

\item{test_server}{(\code{character(1)})\cr
Whether to use the OpenML test server or public server.
Defaults to value of option \code{"mlr3oml.test_server"}, or \code{FALSE} if not set.}
}
\value{
(\code{\link{OMLObject}})
}
\description{
Functions to create OpenML objects. The following functions are available:
\itemize{
\item \code{odt()} - creates an instance of the R6 class \code{\link{OMLData}}.
\item \code{otsk()} - creates an instance of the R6 class \code{\link{OMLTask}}.
\item \code{oflw()} - creates an instance of the R6 class \code{\link{OMLFlow}}.
\item \code{orn()} - creates an instance of the R6 class \code{\link{OMLRun}}.
\item \code{ocl()} - creates an instance of the R6 class \code{\link{OMLCollection}}.
}
}
