% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_collapse.R
\name{str_collapse}
\alias{str_collapse}
\title{Collapse Strings}
\usage{
str_collapse(str, sep = ", ", quote = "", n = Inf,
  ellipsis = "[...]")
}
\arguments{
\item{str}{:: \code{character()}\cr
Vector of strings.}

\item{sep}{:: \code{character(1)}\cr
String used to collapse the elements of \code{x}.}

\item{quote}{:: \code{character(1)}\cr
Quotes to use around each element of \code{x}.}

\item{n}{:: \code{integer(1)}\cr
Number of elements to keep from \code{x}. See \code{\link[utils:head]{utils::head()}}.}

\item{ellipsis}{:: \code{character(1)}\cr
If the string has to be shortened, this is signaled by appending \code{ellipsis} to \code{str}. Default is \code{" [...]"}.}
}
\value{
(\code{character(1)}).
}
\description{
Collapse multiple strings into a single string.
}
\examples{
str_collapse(letters, quote = "'", n = 5)
}
