% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerRegrRanger.R
\name{mlr_learners_regr.ranger}
\alias{mlr_learners_regr.ranger}
\alias{LearnerRegrRanger}
\title{Ranger Regression Learner}
\description{
Random regression forest.
Calls \code{\link[ranger:ranger]{ranger::ranger()}} from package \CRANpkg{ranger}.
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:\preformatted{mlr_learners$get("regr.ranger")
lrn("regr.ranger")
}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{regr}
\item Predict Types: \dQuote{response}, \dQuote{se}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, \dQuote{character}, \dQuote{factor}, \dQuote{ordered}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3learners}, \CRANpkg{ranger}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   alpha \tab numeric \tab 0.5 \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   always.split.variables \tab list \tab - \tab  \tab - \cr
   holdout \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   importance \tab character \tab - \tab none, impurity, impurity_corrected, permutation \tab - \cr
   keep.inbag \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   max.depth \tab integer \tab NULL \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   min.node.size \tab integer \tab 5 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   min.prop \tab numeric \tab 0.1 \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   minprop \tab numeric \tab 0.1 \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   mtry \tab integer \tab - \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   mtry.ratio \tab numeric \tab - \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   num.random.splits \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   num.threads \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   num.trees \tab integer \tab 500 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   oob.error \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   quantreg \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   regularization.factor \tab list \tab 1 \tab  \tab - \cr
   regularization.usedepth \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   replace \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   respect.unordered.factors \tab character \tab ignore \tab ignore, order, partition \tab - \cr
   sample.fraction \tab numeric \tab - \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   save.memory \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   scale.permutation.importance \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   se.method \tab character \tab infjack \tab jack, infjack \tab - \cr
   seed \tab integer \tab NULL \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   split.select.weights \tab list \tab NULL \tab  \tab - \cr
   splitrule \tab character \tab variance \tab variance, extratrees, maxstat \tab - \cr
   verbose \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   write.forest \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
}
}

\section{Custom mlr3 defaults}{

\itemize{
\item \code{num.threads}:
\itemize{
\item Actual default: \code{NULL}, triggering auto-detection of the number of CPUs.
\item Adjusted value: 1.
\item Reason for change: Conflicting with parallelization via \CRANpkg{future}.
}
\item \code{mtry}:
\itemize{
\item This hyperparameter can alternatively be set via our hyperparameter \code{mtry.ratio}
as \code{mtry = max(ceiling(mtry.ratio * n_features), 1)}.
Note that \code{mtry} and \code{mtry.ratio} are mutually exclusive.
}
}
}

\examples{
if (requireNamespace("ranger", quietly = TRUE)) {
  learner = mlr3::lrn("regr.ranger")
  print(learner)

  # available parameters:
learner$param_set$ids()
}
}
\references{
Wright, N. M, Ziegler, Andreas (2017).
\dQuote{ranger: A Fast Implementation of Random Forests for High Dimensional Data in C++ and R.}
\emph{Journal of Statistical Software}, \bold{77}(1), 1--17.
\doi{10.18637/jss.v077.i01}.

Breiman, Leo (2001).
\dQuote{Random Forests.}
\emph{Machine Learning}, \bold{45}(1), 5--32.
ISSN 1573-0565, \doi{10.1023/A:1010933404324}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/basics.html#learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Learner]{Learners}: \link{mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[=Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_classif.cv_glmnet}},
\code{\link{mlr_learners_classif.glmnet}},
\code{\link{mlr_learners_classif.kknn}},
\code{\link{mlr_learners_classif.lda}},
\code{\link{mlr_learners_classif.log_reg}},
\code{\link{mlr_learners_classif.multinom}},
\code{\link{mlr_learners_classif.naive_bayes}},
\code{\link{mlr_learners_classif.nnet}},
\code{\link{mlr_learners_classif.qda}},
\code{\link{mlr_learners_classif.ranger}},
\code{\link{mlr_learners_classif.svm}},
\code{\link{mlr_learners_classif.xgboost}},
\code{\link{mlr_learners_regr.cv_glmnet}},
\code{\link{mlr_learners_regr.glmnet}},
\code{\link{mlr_learners_regr.kknn}},
\code{\link{mlr_learners_regr.km}},
\code{\link{mlr_learners_regr.lm}},
\code{\link{mlr_learners_regr.svm}},
\code{\link{mlr_learners_regr.xgboost}},
\code{\link{mlr_learners_surv.cv_glmnet}},
\code{\link{mlr_learners_surv.glmnet}},
\code{\link{mlr_learners_surv.ranger}},
\code{\link{mlr_learners_surv.xgboost}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}} -> \code{LearnerRegrRanger}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{LearnerRegrRanger$new()}}
\item \href{#method-importance}{\code{LearnerRegrRanger$importance()}}
\item \href{#method-oob_error}{\code{LearnerRegrRanger$oob_error()}}
\item \href{#method-clone}{\code{LearnerRegrRanger$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner">}\href{../../mlr3/html/Learner.html#method-base_learner}{\code{mlr3::Learner$base_learner()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format">}\href{../../mlr3/html/Learner.html#method-format}{\code{mlr3::Learner$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help">}\href{../../mlr3/html/Learner.html#method-help}{\code{mlr3::Learner$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict">}\href{../../mlr3/html/Learner.html#method-predict}{\code{mlr3::Learner$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata">}\href{../../mlr3/html/Learner.html#method-predict_newdata}{\code{mlr3::Learner$predict_newdata()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print">}\href{../../mlr3/html/Learner.html#method-print}{\code{mlr3::Learner$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset">}\href{../../mlr3/html/Learner.html#method-reset}{\code{mlr3::Learner$reset()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train">}\href{../../mlr3/html/Learner.html#method-train}{\code{mlr3::Learner$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRanger$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-importance"></a>}}
\if{latex}{\out{\hypertarget{method-importance}{}}}
\subsection{Method \code{importance()}}{
The importance scores are extracted from the model slot \code{variable.importance}.
Parameter \code{importance.mode} must be set to \code{"impurity"}, \code{"impurity_corrected"}, or
\code{"permutation"}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRanger$importance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named \code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-oob_error"></a>}}
\if{latex}{\out{\hypertarget{method-oob_error}{}}}
\subsection{Method \code{oob_error()}}{
The out-of-bag error, extracted from model slot \code{prediction.error}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRanger$oob_error()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{numeric(1)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRanger$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
