% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectInstanceMultiCrit.R
\name{FSelectInstanceMultiCrit}
\alias{FSelectInstanceMultiCrit}
\title{Class for Multi Criteria Feature Selection}
\description{
The \link{FSelectInstanceMultiCrit} specifies a feature selection problem for \link[=FSelector]{FSelectors}.
The function \code{\link[=fsi]{fsi()}} creates a \link{FSelectInstanceMultiCrit} and the function \code{\link[=fselect]{fselect()}} creates an instance internally.
}
\section{Resources}{

\itemize{
\item \href{https://mlr3book.mlr-org.com/feature-selection.html#fs-wrapper}{book chapter} on feature selection.
\item \href{https://mlr-org.com/gallery/optimization/2020-09-14-mlr3fselect-basic/}{gallery post} on feature selection on the Titanic data set.
}
}

\section{Analysis}{

For analyzing the feature selection results, it is recommended to pass the archive to \code{as.data.table()}.
The returned data table is joined with the benchmark result which adds the \link[mlr3:ResampleResult]{mlr3::ResampleResult} for each feature set.

The archive provides various getters (e.g. \verb{$learners()}) to ease the access.
All getters extract by position (\code{i}) or unique hash (\code{uhash}).
For a complete list of all getters see the methods section.

The benchmark result (\verb{$benchmark_result}) allows to score the feature sets again on a different measure.
Alternatively, measures can be supplied to \code{as.data.table()}.
}

\examples{
# Feature selection on Palmer Penguins data set
\donttest{

task = tsk("penguins")

# Construct feature selection instance
instance = fsi(
  task = task,
  learner = lrn("classif.rpart"),
  resampling = rsmp("cv", folds = 3),
  measures = msrs(c("classif.ce", "time_train")),
  terminator = trm("evals", n_evals = 4)
)

# Choose optimization algorithm
fselector = fs("random_search", batch_size = 2)

# Run feature selection
fselector$optimize(instance)

# Optimal feature sets
instance$result_feature_set

# Inspect all evaluated sets
as.data.table(instance$archive)
}
}
\section{Super classes}{
\code{\link[bbotk:OptimInstance]{bbotk::OptimInstance}} -> \code{\link[bbotk:OptimInstanceMultiCrit]{bbotk::OptimInstanceMultiCrit}} -> \code{FSelectInstanceMultiCrit}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{result_feature_set}}{(list of \code{character()})\cr
Feature sets for task subsetting.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FSelectInstanceMultiCrit-new}{\code{FSelectInstanceMultiCrit$new()}}
\item \href{#method-FSelectInstanceMultiCrit-assign_result}{\code{FSelectInstanceMultiCrit$assign_result()}}
\item \href{#method-FSelectInstanceMultiCrit-print}{\code{FSelectInstanceMultiCrit$print()}}
\item \href{#method-FSelectInstanceMultiCrit-clone}{\code{FSelectInstanceMultiCrit$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="clear"><a href='../../bbotk/html/OptimInstance.html#method-OptimInstance-clear'><code>bbotk::OptimInstance$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="eval_batch"><a href='../../bbotk/html/OptimInstance.html#method-OptimInstance-eval_batch'><code>bbotk::OptimInstance$eval_batch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="format"><a href='../../bbotk/html/OptimInstance.html#method-OptimInstance-format'><code>bbotk::OptimInstance$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="objective_function"><a href='../../bbotk/html/OptimInstance.html#method-OptimInstance-objective_function'><code>bbotk::OptimInstance$objective_function()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectInstanceMultiCrit-new"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectInstanceMultiCrit-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectInstanceMultiCrit$new(
  task,
  learner,
  resampling,
  measures,
  terminator,
  store_benchmark_result = TRUE,
  store_models = FALSE,
  check_values = FALSE,
  callbacks = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link[mlr3:Task]{mlr3::Task})\cr
Task to operate on.}

\item{\code{learner}}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Learner to optimize the feature subset for.}

\item{\code{resampling}}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Resampling that is used to evaluated the performance of the feature subsets.
Uninstantiated resamplings are instantiated during construction so that all feature subsets are evaluated on the same data splits.
Already instantiated resamplings are kept unchanged.}

\item{\code{measures}}{(list of \link[mlr3:Measure]{mlr3::Measure})\cr
Measures to optimize.
If \code{NULL}, \CRANpkg{mlr3}'s default measure is used.}

\item{\code{terminator}}{(\link{Terminator})\cr
Stop criterion of the feature selection.}

\item{\code{store_benchmark_result}}{(\code{logical(1)})\cr
Store benchmark result in archive?}

\item{\code{store_models}}{(\code{logical(1)}).
Store models in benchmark result?}

\item{\code{check_values}}{(\code{logical(1)})\cr
Check the parameters before the evaluation and the results for
validity?}

\item{\code{callbacks}}{(list of \link{CallbackFSelect})\cr
List of callbacks.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectInstanceMultiCrit-assign_result"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectInstanceMultiCrit-assign_result}{}}}
\subsection{Method \code{assign_result()}}{
The \link{FSelector} object writes the best found feature subsets and estimated performance values here.
For internal use.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectInstanceMultiCrit$assign_result(xdt, ydt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\code{data.table::data.table()})\cr
x values as \code{data.table}. Each row is one point. Contains the value in
the \emph{search space} of the \link{FSelectInstanceMultiCrit} object. Can contain
additional columns for extra information.}

\item{\code{ydt}}{(\code{data.table::data.table()})\cr
Optimal outcomes, e.g. the Pareto front.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectInstanceMultiCrit-print"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectInstanceMultiCrit-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectInstanceMultiCrit$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectInstanceMultiCrit-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectInstanceMultiCrit-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectInstanceMultiCrit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
