% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackFSelect.R
\name{CallbackFSelect}
\alias{CallbackFSelect}
\title{Create Feature Selection Callback}
\description{
Specialized \link[bbotk:CallbackOptimization]{bbotk::CallbackOptimization} for feature selection.
Callbacks allow to customize the behavior of processes in mlr3fselect.
The \code{\link[=callback_fselect]{callback_fselect()}} function creates a \link{CallbackFSelect}.
Predefined callbacks are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_callbacks} and can be retrieved with \code{\link[=clbk]{clbk()}}.
For more information on callbacks see \code{\link[=callback_fselect]{callback_fselect()}}.
}
\examples{
# Write archive to disk
callback_fselect("mlr3fselect.backup",
  on_optimization_end = function(callback, context) {
    saveRDS(context$instance$archive, "archive.rds")
  }
)
}
\section{Super classes}{
\code{\link[mlr3misc:Callback]{mlr3misc::Callback}} -> \code{\link[bbotk:CallbackOptimization]{bbotk::CallbackOptimization}} -> \code{CallbackFSelect}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{on_eval_after_design}}{(\verb{function()})\cr
Stage called after design is created.
Called in \code{ObjectiveFSelect$eval_many()}.}

\item{\code{on_eval_after_benchmark}}{(\verb{function()})\cr
Stage called after feature sets are evaluated.
Called in \code{ObjectiveFSelect$eval_many()}.}

\item{\code{on_eval_before_archive}}{(\verb{function()})\cr
Stage called before performance values are written to the archive.
Called in \code{ObjectiveFSelect$eval_many()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CallbackFSelect-clone}{\code{CallbackFSelect$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="call"><a href='../../mlr3misc/html/Callback.html#method-Callback-call'><code>mlr3misc::Callback$call()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="format"><a href='../../mlr3misc/html/Callback.html#method-Callback-format'><code>mlr3misc::Callback$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="help"><a href='../../mlr3misc/html/Callback.html#method-Callback-help'><code>mlr3misc::Callback$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="initialize"><a href='../../mlr3misc/html/Callback.html#method-Callback-initialize'><code>mlr3misc::Callback$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="print"><a href='../../mlr3misc/html/Callback.html#method-Callback-print'><code>mlr3misc::Callback$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackFSelect-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackFSelect-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackFSelect$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
