% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterNJMIM.R
\name{mlr_filters_njmim}
\alias{mlr_filters_njmim}
\alias{FilterNJMIM}
\title{Minimal Normalised Joint Mutual Information Maximisation Filter}
\description{
Minimal normalised joint mutual information maximisation filter
calling \code{\link[praznik:NJMIM]{praznik::NJMIM()}} from package \CRANpkg{praznik}.

This filter supports partial scoring (see \link{Filter}).
}
\details{
As the scores calculated by the \CRANpkg{praznik} package are not monotone due
to the greedy forward fashion, the returned scores simply reflect the selection order:
\code{1}, \code{(k-1)/k}, ..., \code{1/k} where \code{k} is the number of selected features.

Threading is disabled by default (hyperparameter \code{threads} is set to 1).
Set to a number \verb{>= 2} to enable threading, or to \code{0} for auto-detecting the number
of available cores.
}
\examples{
task = mlr3::tsk("iris")
filter = flt("njmim")
filter$calculate(task, nfeat = 2)
as.data.table(filter)
}
\references{
Kursa MB (2021).
\dQuote{Praznik: High performance information-based feature selection.}
\emph{SoftwareX}, \bold{16}, 100819.
\doi{10.1016/j.softx.2021.100819}.

For a benchmark of filter methods:

Bommert A, Sun X, Bischl B, Rahnenführer J, Lang M (2020).
\dQuote{Benchmark for filter methods for feature selection in high-dimensional classification data.}
\emph{Computational Statistics & Data Analysis}, \bold{143}, 106839.
\doi{10.1016/j.csda.2019.106839}.
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: 
\code{\link{Filter}},
\code{\link{mlr_filters_anova}},
\code{\link{mlr_filters_auc}},
\code{\link{mlr_filters_carscore}},
\code{\link{mlr_filters_cmim}},
\code{\link{mlr_filters_correlation}},
\code{\link{mlr_filters_disr}},
\code{\link{mlr_filters_find_correlation}},
\code{\link{mlr_filters_importance}},
\code{\link{mlr_filters_information_gain}},
\code{\link{mlr_filters_jmim}},
\code{\link{mlr_filters_jmi}},
\code{\link{mlr_filters_kruskal_test}},
\code{\link{mlr_filters_mim}},
\code{\link{mlr_filters_mrmr}},
\code{\link{mlr_filters_performance}},
\code{\link{mlr_filters_permutation}},
\code{\link{mlr_filters_relief}},
\code{\link{mlr_filters_selected_features}},
\code{\link{mlr_filters_variance}},
\code{\link{mlr_filters}}
}
\concept{Filter}
\section{Super class}{
\code{\link[mlr3filters:Filter]{mlr3filters::Filter}} -> \code{FilterNJMIM}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FilterNJMIM$new()}}
\item \href{#method-clone}{\code{FilterNJMIM$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="calculate">}\href{../../mlr3filters/html/Filter.html#method-calculate}{\code{mlr3filters::Filter$calculate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="format">}\href{../../mlr3filters/html/Filter.html#method-format}{\code{mlr3filters::Filter$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="help">}\href{../../mlr3filters/html/Filter.html#method-help}{\code{mlr3filters::Filter$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="print">}\href{../../mlr3filters/html/Filter.html#method-print}{\code{mlr3filters::Filter$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a FilterNJMIM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterNJMIM$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterNJMIM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
