% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterJMIM.R
\name{FilterJMIM}
\alias{FilterJMIM}
\alias{mlr_filters_jmim}
\title{Minimal Joint Mutual Information Maximisation Filter}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Filter}.}
\description{
Minimal joint mutual information maximisation filter calling
\code{\link[praznik:JMIM]{praznik::JMIM()}} in package \CRANpkg{praznik}.

This filter supports partial scoring (see \link{Filter}).
}
\section{Construction}{
\preformatted{FilterJMIM$new()
mlr_filters$get("jmim")
flt("jmim")
}
}

\examples{
task = mlr3::tsk("iris")
filter = flt("jmim")
filter$calculate(task, nfeat = 2)
as.data.table(filter)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: 
\code{\link{FilterAUC}},
\code{\link{FilterAnova}},
\code{\link{FilterCMIM}},
\code{\link{FilterCarScore}},
\code{\link{FilterCorrelation}},
\code{\link{FilterDISR}},
\code{\link{FilterImportance}},
\code{\link{FilterInformationGain}},
\code{\link{FilterJMI}},
\code{\link{FilterKruskalTest}},
\code{\link{FilterMIM}},
\code{\link{FilterMRMR}},
\code{\link{FilterNJMIM}},
\code{\link{FilterPerformance}},
\code{\link{FilterVariance}},
\code{\link{Filter}},
\code{\link{mlr_filters}}
}
\concept{Filter}
