% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterImportance.R
\docType{data}
\name{FilterImportance}
\alias{FilterImportance}
\alias{mlr_filters_variable_importance}
\title{Filter for Embedded Feature Selection via Variable Importance}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Filter}.}
\description{
Variable Importance filter using embedded feature selection of
machine learning algorithms. Takes a \link[mlr3:Learner]{mlr3::Learner} which is capable of
extracting the variable importance (property "importance"), fits the model
and extracts the importance values to use as filter scores.
}
\section{Construction}{
\preformatted{FilterImportance$new(learner = mlr3::lrn("classif.rpart"))
mlr_filters$get("importance")
flt("importance")
}
\itemize{
\item \code{learner} :: \link[mlr3:Learner]{mlr3::Learner}\cr
Learner to extract the importance values from.
}
}

\examples{
task = mlr3::tsk("iris")
learner = mlr3::lrn("classif.rpart")
filter = flt("importance", learner = learner)
filter$calculate(task)
as.data.table(filter)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: \code{\link{FilterAUC}},
  \code{\link{FilterAnova}}, \code{\link{FilterCMIM}},
  \code{\link{FilterCarScore}},
  \code{\link{FilterCorrelation}},
  \code{\link{FilterDISR}},
  \code{\link{FilterInformationGain}},
  \code{\link{FilterJMIM}}, \code{\link{FilterJMI}},
  \code{\link{FilterKruskalTest}}, \code{\link{FilterMIM}},
  \code{\link{FilterMRMR}}, \code{\link{FilterNJMIM}},
  \code{\link{FilterPerformance}},
  \code{\link{FilterVariance}}, \code{\link{Filter}},
  \code{\link{mlr_filters}}
}
\concept{Filter}
\keyword{datasets}
