% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClassif_wine.R
\name{mlr_tasks_wine}
\alias{mlr_tasks_wine}
\title{Wine Classification Task}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskClassif}.
}
\source{
Original owners:
Forina, M. et al, PARVUS - An Extendible Package for Data Exploration, Classification and Correlation.
Institute of Pharmaceutical and Food Analysis and Technologies, Via Brigata Salerno, 16147 Genoa, Italy.

Donor:
Stefan Aeberhard, email: stefan@coral.cs.jcu.edu.au
}
\description{
Wine data set from the UCI machine learning repository (\url{http://archive.ics.uci.edu/dataset/109/wine}).
Results of a chemical analysis of three types of wines grown in the same region in Italy but derived from three different cultivars.
}
\section{Dictionary}{

This \link{Task} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_tasks} or with the associated sugar function \code{\link[=tsk]{tsk()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("wine")
tsk("wine")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{classif}
\item Dimensions: 178x14
\item Properties: \dQuote{multiclass}
\item Has Missings: \code{FALSE}
\item Target: \dQuote{type}
\item Features: \dQuote{alcalinity}, \dQuote{alcohol}, \dQuote{ash}, \dQuote{color}, \dQuote{dilution}, \dQuote{flavanoids}, \dQuote{hue}, \dQuote{magnesium}, \dQuote{malic}, \dQuote{nonflavanoids}, \dQuote{phenols}, \dQuote{proanthocyanins}, \dQuote{proline}
}
}

\references{
Dua, Dheeru, Graff, Casey (2017).
\dQuote{UCI Machine Learning Repository.}
\url{http://archive.ics.uci.edu/datasets}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/basics.html#tasks}
\item Package \CRANpkg{mlr3data} for more toy tasks.
\item Package \CRANpkg{mlr3oml} for downloading tasks from \url{https://www.openml.org}.
\item Package \CRANpkg{mlr3viz} for some generic visualizations.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Task]{Tasks}: \link{mlr_tasks}
\item \code{as.data.table(mlr_tasks)} for a table of available \link[=Task]{Tasks} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3fselect} and \CRANpkg{mlr3filters} for feature selection and feature filtering.
\item Extension packages for additional task types:
\itemize{
\item Unsupervised clustering: \CRANpkg{mlr3cluster}
\item Probabilistic supervised regression and survival analysis: \url{https://mlr3proba.mlr-org.com/}.
}
}

Other Task: 
\code{\link{TaskClassif}},
\code{\link{TaskRegr}},
\code{\link{TaskSupervised}},
\code{\link{TaskUnsupervised}},
\code{\link{Task}},
\code{\link{mlr_tasks_boston_housing}},
\code{\link{mlr_tasks_breast_cancer}},
\code{\link{mlr_tasks_german_credit}},
\code{\link{mlr_tasks_iris}},
\code{\link{mlr_tasks_mtcars}},
\code{\link{mlr_tasks_penguins}},
\code{\link{mlr_tasks_pima}},
\code{\link{mlr_tasks_sonar}},
\code{\link{mlr_tasks_spam}},
\code{\link{mlr_tasks_zoo}},
\code{\link{mlr_tasks}}
}
\concept{Task}
