% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataBackendMatrix.R, R/as_data_backend.R
\name{as_data_backend.Matrix}
\alias{as_data_backend.Matrix}
\alias{as_data_backend}
\alias{as_data_backend.data.frame}
\title{Create a Data Backend}
\usage{
\method{as_data_backend}{Matrix}(data, primary_key = NULL, dense = NULL, ...)

as_data_backend(data, primary_key = NULL, ...)

\method{as_data_backend}{data.frame}(data, primary_key = NULL, keep_rownames = FALSE, ...)
}
\arguments{
\item{data}{(\code{\link[=data.frame]{data.frame()}})\cr
The input \code{\link[=data.frame]{data.frame()}}.
Automatically converted to a \code{\link[data.table:data.table]{data.table::data.table()}}.}

\item{primary_key}{(\code{character(1)} | \code{integer()})\cr
Name of the primary key column, or integer vector of row ids.}

\item{dense}{(\code{\link[=data.frame]{data.frame()}}).
Dense data.}

\item{...}{(any)\cr
Additional arguments passed to the respective \link{DataBackend} method.}

\item{keep_rownames}{(\code{logical(1)} | \code{character(1)})\cr
If \code{TRUE} or a single string, keeps the row names of \code{data} as a new column.
The column is named like the provided string, defaulting to \code{"..rownames"} for \code{keep_rownames == TRUE}.
Note that the created column will be used as a regular feature by the task unless you manually change the column role.
Also see \code{\link[data.table:as.data.table]{data.table::as.data.table()}}.}
}
\value{
\link{DataBackend}.
}
\description{
Wraps a \link{DataBackend} around data.
\CRANpkg{mlr3} ships with methods for \code{data.frame} (converted to a \link{DataBackendDataTable}
and \code{Matrix} from package \CRANpkg{Matrix} (converted to a \link{DataBackendMatrix}).

Additional methods are implemented in the package \CRANpkg{mlr3db}, e.g. to connect
to real DBMS like PostgreSQL (via \CRANpkg{dbplyr}) or DuckDB (via \CRANpkg{DBI}/\CRANpkg{duckdb}).
}
\examples{
# create a new backend using the penguins data:
as_data_backend(palmerpenguins::penguins)
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/technical.html#backends}
\item Package \CRANpkg{mlr3db} to interface out-of-memory data,
e.g. SQL servers or \CRANpkg{duckdb}.
}

Other DataBackend: 
\code{\link{DataBackendDataTable}},
\code{\link{DataBackendMatrix}},
\code{\link{DataBackend}}
}
\concept{DataBackend}
