% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionClassif.R
\name{PredictionClassif}
\alias{PredictionClassif}
\title{Prediction Object for Classification}
\description{
This object wraps the predictions returned by a learner of class \link{LearnerClassif}, i.e.
the predicted response and class probabilities.

If the response is not provided during construction, but class probabilities are,
the response is calculated from the probabilities: the class label with the highest
probability is chosen. In case of ties, a label is selected randomly.
}
\note{
If this object is constructed manually, make sure that the factor levels for \code{truth}
have the same levels as the task, in the same order.
In case of binary classification tasks, the positive class label must be the first level.
}
\section{Thresholding}{

If probabilities are stored, it is possible to change the threshold which determines the predicted class label.
Usually, the label of the class with the highest predicted probability is selected.
For binary classification problems, such an threshold defaults to 0.5.
For cost-sensitive or imbalanced classification problems, manually adjusting the threshold can increase
the predictive performance.
\itemize{
\item For binary problems only a single threshold value can be set.
If the probability exceeds the threshold, the positive class is predicted.
If the probability equals the threshold, the label is selected randomly.
\item For binary and multi-class problems, a named numeric vector of thresholds can be set.
The length and names must correspond to the number of classes and class names, respectively.
To determine the class label, the probabilities are divided by the threshold.
This results in a ratio > 1 if the probability exceeds the threshold, and a ratio < 1 otherwise.
Note that it is possible that either none or multiple ratios are greater than 1 at the same time.
Anyway, the class label with maximum ratio is selected.
In case of ties in the ratio, one of the tied class labels is selected randomly.

Note that there are the following edge cases for threshold equal to \code{0} which are handled specially:
\enumerate{
\item With threshold 0 the resulting ratio gets \code{Inf} and thus gets always selected.
If there are multiple ratios with value \code{Inf}, one is selected according to \code{ties_method} (randomly per default).
\item If additionally the predicted probability is also 0, the ratio \code{0/0} results in \code{NaN} values.
These are simply replaced by \code{0} and thus will never get selected.
}
}
}

\examples{
task = tsk("penguins")
learner = lrn("classif.rpart", predict_type = "prob")
learner$train(task)
p = learner$predict(task)
p$predict_types
head(as.data.table(p))

# confusion matrix
p$confusion

# change threshold
th = c(0.05, 0.9, 0.05)
names(th) = task$class_names

# new predictions
p$set_threshold(th)$response
p$score(measures = msr("classif.ce"))
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/train-predict.html}
\item Package \CRANpkg{mlr3viz} for some generic visualizations.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
}

Other Prediction: 
\code{\link{PredictionRegr}},
\code{\link{Prediction}}
}
\concept{Prediction}
\section{Super class}{
\code{\link[mlr3:Prediction]{mlr3::Prediction}} -> \code{PredictionClassif}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{response}}{(\code{factor()})\cr
Access to the stored predicted class labels.}

\item{\code{prob}}{(\code{matrix()})\cr
Access to the stored probabilities.}

\item{\code{confusion}}{(\code{matrix()})\cr
Confusion matrix, as resulting from the comparison of truth and response.
Truth is in columns, predicted response is in rows.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PredictionClassif$new()}}
\item \href{#method-set_threshold}{\code{PredictionClassif$set_threshold()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="format">}\href{../../mlr3/html/Prediction.html#method-format}{\code{mlr3::Prediction$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="help">}\href{../../mlr3/html/Prediction.html#method-help}{\code{mlr3::Prediction$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="print">}\href{../../mlr3/html/Prediction.html#method-print}{\code{mlr3::Prediction$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="score">}\href{../../mlr3/html/Prediction.html#method-score}{\code{mlr3::Prediction$score()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictionClassif$new(
  task = NULL,
  row_ids = task$row_ids,
  truth = task$truth(),
  response = NULL,
  prob = NULL,
  check = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link{TaskClassif})\cr
Task, used to extract defaults for \code{row_ids} and \code{truth}.}

\item{\code{row_ids}}{(\code{integer()})\cr
Row ids of the predicted observations, i.e. the row ids of the test set.}

\item{\code{truth}}{(\code{factor()})\cr
True (observed) labels. See the note on manual construction.}

\item{\code{response}}{(\code{character()} | \code{factor()})\cr
Vector of predicted class labels.
One element for each observation in the test set.
Character vectors are automatically converted to factors.
See the note on manual construction.}

\item{\code{prob}}{(\code{matrix()})\cr
Numeric matrix of posterior class probabilities with one column for each class
and one row for each observation in the test set.
Columns must be named with class labels, row names are automatically removed.
If \code{prob} is provided, but \code{response} is not, the class labels are calculated from
the probabilities using \code{\link[=max.col]{max.col()}} with \code{ties.method} set to \code{"random"}.}

\item{\code{check}}{(\code{logical(1)})\cr
If \code{TRUE}, performs some argument checks and predict type conversions.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_threshold"></a>}}
\if{latex}{\out{\hypertarget{method-set_threshold}{}}}
\subsection{Method \code{set_threshold()}}{
Sets the prediction response based on the provided threshold.
See the section on thresholding for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictionClassif$set_threshold(threshold, ties_method = "random")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold}}{(\code{numeric()}).}

\item{\code{ties_method}}{(\code{character(1)})\cr
One of \code{"random"}, \code{"first"} or \code{"last"} (c.f. \code{\link[=max.col]{max.col()}}) to determine how to deal with
tied probabilities.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
}
