% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingSubsampling.R
\name{ResamplingSubsampling}
\alias{ResamplingSubsampling}
\alias{mlr_resamplings_subsampling}
\title{Subsampling Resampling}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Resampling}.}
\description{
Splits data \code{repeats} (default: 30) times into training and test set
with a ratio of \code{ratio} (default: 2/3) observations going into the training set.
}
\section{Construction}{
\preformatted{ResamplingSubsampling$new()
mlr_resamplings$get("subsampling")
rsmp("subsampling")
}
}

\section{Fields}{

See \link{Resampling}.
}

\section{Methods}{

See \link{Resampling}.
}

\section{Parameters}{

\itemize{
\item \code{repeats} :: \code{integer(1)}\cr
Number of repetitions.
\item \code{ratio} :: \code{numeric(1)}\cr
Ratio of observations to put into the training set.
}
}

\examples{
# Create a task with 10 observations
task = tsk("iris")
task$filter(1:10)

# Instantiate Resampling
rss = rsmp("subsampling", repeats = 2, ratio = 0.5)
rss$instantiate(task)

# Individual sets:
rss$train_set(1)
rss$test_set(1)
intersect(rss$train_set(1), rss$test_set(1))

# Internal storage:
rss$instance$train # list of index vectors
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Resampling]{Resamplings}: \link{mlr_resamplings}

\code{as.data.table(mlr_resamplings)} for a complete table of all (also dynamically created) \link{Resampling} implementations.
}
