% Generated by roxygen2 (4.0.2): do not edit by hand
\name{impute}
\alias{impute}
\title{Impute and re-impute data}
\usage{
impute(data, target = character(0L), classes = list(), cols = list(),
  dummy.classes = character(0L), dummy.cols = character(0L),
  dummy.type = "factor", force.dummies = FALSE, impute.new.levels = TRUE,
  recode.factor.levels = TRUE)
}
\arguments{
\item{data}{[\code{data.frame}]\cr
Input data.}

\item{target}{[\code{character}]\cr
Name of the column(s) specifying the response.
Default is \code{character(0)}.}

\item{classes}{[\code{named list}]\cr
Named list containing imputation techniques for classes of columns.
E.g. \code{list(numeric = imputeMedian())}.}

\item{cols}{[\code{named list}]\cr
Named list containing names of imputation methods to impute missing values
in the data column referenced by the list element's name. Overrules imputation set via
\code{classes}.}

\item{dummy.classes}{[\code{character}]\cr
Classes of columns to create dummy columns for.
Default is \code{character(0)}.}

\item{dummy.cols}{[\code{character}]\cr
Column names to create dummy columns (containing binary missing indicator) for.
Default is \code{character(0)}.}

\item{dummy.type}{[\code{character(1)}]\cr
How dummy columns are encoded. Either as 0/1 with type \dQuote{numeric}
or as \dQuote{factor}.
Default is \dQuote{factor}.}

\item{force.dummies}{[\code{logical(1)}]\cr
Force dummy creation even if the respective data column does not
contain any NAs. Note that (a) most learners will complain about
constant columns created this way but (b) your feature set might
be stochastic if you turn this off.
Default is \code{FALSE}.}

\item{impute.new.levels}{[\code{logical(1)}]\cr
If new, unencountered factor level occur during reimputation,
should these be handled as NAs and then be imputed the same way?
Default is \code{TRUE}.}

\item{recode.factor.levels}{[\code{logical(1)}]\cr
Recode factor levels after reimputation, so they match the respective element of
\code{lvls} (in the description object) and therefore match the levels of the
feature factor in the training data after imputation?.
Default is \code{TRUE}.}
}
\value{
[\code{list}]
  \item{data [\code{data.frame}]}{Imputed data.}
  \item{desc [\code{ImputationDesc}]}{Description object.}
}
\description{
Allows imputation of missing feature values through various techniques.
Note that you have the possibility to re-impute a data set
in the same way as the imputation was performed during training.
This especially comes in handy during resampling when one wants to perform the
same imputation on the test set as on the training set.

The function \code{impute} performs the imputation on a data set and returns,
alongside with the imputed data set, an \dQuote{ImputationDesc} object
which can contain \dQuote{learned} coefficients and helpful data.
It can then be passed together with a new data set to \code{\link{reimpute}}.

The imputation techniques can be specified for certain features or for feature classes,
see function arguments.

You can either provide an arbitrary object, use a built-in imputation method listed
under \code{\link{imputations}} or create one yourself using \code{\link{makeImputeMethod}}.
}
\details{
The description object contains these slots
\describe{
  \item{target [\code{character}]}{See argument.}
  \item{features [\code{character}]}{Feature names, these are the column names of \code{data},
    excluding \code{target}.}
  \item{lvls [\code{named list}]}{Mapping of column names of factor features to their levels,
    including newly created ones during imputation.}
  \item{impute [\code{named list}]}{Mapping of column names to imputation functions.}
  \item{dummies [\code{named list}]}{Mapping of column names to imputation functions.}
  \item{impute.new.levels [\code{logical(1)}]}{See argument.}
  \item{recode.factor.levels [\code{logical(1)}]}{See argument.}
}
}
\examples{
df = data.frame(x = c(1, 1, NA), y = factor(c("a", "a", "b")), z = 1:3)
imputed = impute(df, target = character(0), cols = list(x = 99, y = imputeMode()))
print(imputed$data)
reimpute(data.frame(x = NA), imputed$desc)
}
\seealso{
Other impute: \code{\link{imputations}},
  \code{\link{imputeConstant}}, \code{\link{imputeHist}},
  \code{\link{imputeLearner}}, \code{\link{imputeMax}},
  \code{\link{imputeMean}}, \code{\link{imputeMedian}},
  \code{\link{imputeMin}}, \code{\link{imputeMode}},
  \code{\link{imputeNormal}}, \code{\link{imputeUniform}};
  \code{\link{makeImputeMethod}};
  \code{\link{makeImputeWrapper}}; \code{\link{reimpute}}
}

