% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TuneResult.R
\name{TuneResult}
\alias{TuneResult}
\title{Result of tuning.}
\description{
Container for results of hyperparameter tuning.
Contains the obtained point in search space, its performance values
and the optimization path which lead there.

Object members:
\describe{
\item{learner [\code{\link{Learner}}]}{Learner that was optimized.}
\item{control [\code{\link{TuneControl}}]}{Control object from tuning.}
\item{x [\code{list}]}{Named list of hyperparameter values identified as optimal.
  Note that when you have trafos on some of your params, \code{x} will always be
  on the TRANSFORMED scale so you directly use it.}
\item{y [\code{numeric}]}{Performance values for optimal \code{x}.}
\item{threshold [\code{numeric}]}{Vector of finally found and used thresholds
  if \code{tune.threshold} was enabled in \code{\link{TuneControl}}, otherwise not present and
  hence \code{NULL}.}
\item{opt.path [\code{\link[ParamHelpers]{OptPath}}]}{Optimization path which lead to \code{x}.
  Note that when you have trafos on some of your params, the opt.path always contains the
  UNTRANSFORMED values on the original scale. You can simply call \code{trafoOptPath(opt.path)} to
  transform them, or, \code{as.data.frame{trafoOptPath(opt.path)}}}
}
}
