% Generated by roxygen2 (4.0.1): do not edit by hand
\name{listLearners}
\alias{listLearners}
\alias{listLearners.SupervisedTask}
\alias{listLearners.character}
\alias{listLearners.default}
\title{Find matching learning algorithms.}
\usage{
listLearners(obj = NA_character_, properties = character(0L),
  quiet = TRUE, warn.missing.packages = TRUE, create = FALSE)

\method{listLearners}{default}(obj, properties = character(0L),
  quiet = TRUE, warn.missing.packages = TRUE, create = FALSE)

\method{listLearners}{character}(obj, properties = character(0L),
  quiet = TRUE, warn.missing.packages = TRUE, create = FALSE)

\method{listLearners}{SupervisedTask}(obj, properties = character(0L),
  quiet = TRUE, warn.missing.packages = TRUE, create = FALSE)
}
\arguments{
\item{obj}{[\code{character(1)} | \code{\link{SupervisedTask}}]\cr
Either a task or the type of the task, in the latter case one of:
\dQuote{classif}, \dQuote{regr},  \dQuote{surv}, dQuote{costsens}.
Default is \code{NA}, matching all types.}

\item{properties}{[\code{character}]\cr
Set of required properties to filter for. Default is \code{character(0)}.}

\item{quiet}{[\code{logical(1)}]\cr
Construct learners quietly to check their properties, shows no package startup messages.
Turn off if you suspect errors.
Default is \code{TRUE}.}

\item{warn.missing.packages}{[\code{logical(1)}]\cr
If some learner cannot be constructed because its package is missing,
should a warning be shown?
Default is \code{TRUE}.}

\item{create}{[\code{logical(1)}]\cr
Instantiate objects (or return strings)?
Default is \code{FALSE}.}
}
\value{
[\code{character} | \code{list} of \code{\link{Learner}}]. Class names of matching
  learners or instantiated objects.
}
\description{
Returns the class names of learning algorithms which have specific characteristics, e.g.
whether they supports missing values, case weights, etc.

Note that the packages of all learners are loaded during the search.
}

