% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhmkin.R
\name{mhmkin}
\alias{mhmkin}
\alias{mhmkin.mmkin}
\alias{mhmkin.list}
\alias{[.mhmkin}
\alias{print.mhmkin}
\title{Fit nonlinear mixed-effects models built from one or more kinetic
degradation models and one or more error models}
\usage{
mhmkin(objects, ...)

\method{mhmkin}{mmkin}(objects, ...)

\method{mhmkin}{list}(
  objects,
  backend = "saemix",
  algorithm = "saem",
  no_random_effect = NULL,
  auto_ranef_threshold = 3,
  ...,
  cores = if (Sys.info()["sysname"] == "Windows") 1 else parallel::detectCores(),
  cluster = NULL
)

\method{[}{mhmkin}(x, i, j, ..., drop = FALSE)

\method{print}{mhmkin}(x, ...)
}
\arguments{
\item{objects}{A list of \link{mmkin} objects containing fits of the same
degradation models to the same data, but using different error models.
Alternatively, a single \link{mmkin} object containing fits of several
degradation models to the same data}

\item{\dots}{Further arguments that will be passed to the nonlinear mixed-effects
model fitting function.}

\item{backend}{The backend to be used for fitting. Currently, only saemix is
supported}

\item{algorithm}{The algorithm to be used for fitting (currently not used)}

\item{no_random_effect}{Default is NULL and will be passed to \link{saem}. If
you specify "auto", random effects are only included if the number
of datasets in which the parameter passed the t-test is at least 'auto_ranef_threshold'.
Beware that while this may make for convenient model reduction or even
numerical stability of the algorithm, it will likely lead to
underparameterised models.}

\item{auto_ranef_threshold}{See 'no_random_effect.}

\item{cores}{The number of cores to be used for multicore processing. This
is only used when the \code{cluster} argument is \code{NULL}. On Windows
machines, cores > 1 is not supported, you need to use the \code{cluster}
argument to use multiple logical processors. Per default, all cores detected
by \code{\link[parallel:detectCores]{parallel::detectCores()}} are used, except on Windows where the default
is 1.}

\item{cluster}{A cluster as returned by \link{makeCluster} to be used for
parallel execution.}

\item{x}{An \link{mhmkin} object.}

\item{i}{Row index selecting the fits for specific models}

\item{j}{Column index selecting the fits to specific datasets}

\item{drop}{If FALSE, the method always returns an mhmkin object, otherwise
either a list of fit objects or a single fit object.}
}
\value{
A two-dimensional \link{array} of fit objects and/or try-errors that can
be indexed using the degradation model names for the first index (row index)
and the error model names for the second index (column index), with class
attribute 'mhmkin'.

An object of class \code{\link{mhmkin}}.
}
\description{
The name of the methods expresses that (\strong{m}ultiple) \strong{h}ierarchichal
(also known as multilevel) \strong{m}ulticompartment \strong{kin}etic models are
fitted. Our kinetic models are nonlinear, so we can use various nonlinear
mixed-effects model fitting functions.
}
\seealso{
\code{\link{[.mhmkin}} for subsetting \link{mhmkin} objects
}
\author{
Johannes Ranke
}
