% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parms.mkinfit.R
\name{parms}
\alias{parms}
\alias{parms.mkinfit}
\alias{parms.mmkin}
\title{Extract model parameters from mkinfit models}
\usage{
parms(object, ...)

\method{parms}{mkinfit}(object, transformed = FALSE, ...)

\method{parms}{mmkin}(object, transformed = FALSE, ...)
}
\arguments{
\item{object}{A fitted model object. Methods are implemented for
\code{\link[=mkinfit]{mkinfit()}} objects and for \code{\link[=mmkin]{mmkin()}} objects.}

\item{\dots}{Not used}

\item{transformed}{Should the parameters be returned
as used internally during the optimisation?}
}
\value{
For mkinfit objects, a numeric vector of fitted model parameters.
For mmkin row objects, a matrix with the parameters with a
row for each dataset. If the mmkin object has more than one row, a list of
such matrices is returned.
}
\description{
This function always returns degradation model parameters as well as error
model parameters, in order to avoid working with a fitted model without
considering the error structure that was assumed for the fit.
}
\examples{
# mkinfit objects
fit <- mkinfit("SFO", FOCUS_2006_C, quiet = TRUE)
parms(fit)
parms(fit, transformed = TRUE)

# mmkin objects
ds <- lapply(experimental_data_for_UBA_2019[6:10],
 function(x) subset(x$data[c("name", "time", "value")]))
names(ds) <- paste("Dataset", 6:10)
\dontrun{
fits <- mmkin(c("SFO", "FOMC", "DFOP"), ds, quiet = TRUE, cores = 1)
parms(fits["SFO", ])
parms(fits[, 2])
parms(fits)
parms(fits, transformed = TRUE)
}
}
