% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerRDI}
\alias{mizerRDI}
\title{Get density-independent rate of reproduction needed to project standard
mizer model}
\usage{
mizerRDI(params, n, n_pp, n_other, e_repro, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{e_repro}{An array (species x size) with the energy available for
reproduction as calculated by \code{getERepro()}.}

\item{...}{Unused}
}
\value{
A numeric vector with the rate of egg production for each species.
}
\description{
Calculates the density-independent rate of total egg production \eqn{R_{p.i}}
(units 1/year) before density dependence, by species. This is obtained by
taking the total rate at which energy is invested in reproduction,
multiplying by the reproductive efficiency \code{erepro} and dividing by the egg
size \code{w_min}, and by a factor of two to account for the two sexes.
}
\details{
Used by \code{\link[=getRDD]{getRDD()}} to calculate the actual, density dependent rate.
See \code{\link[=setReproduction]{setReproduction()}} for more details.
}
\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
