% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\docType{methods}
\name{getSSBFrame}
\alias{getSSBFrame}
\alias{getSSBFrame,MizerSim-method}
\title{Get data frame of spawning stock biomass of species through time, 
ready for ggplot2}
\usage{
getSSBFrame(sim, ...)

\S4method{getSSBFrame}{MizerSim}(sim,
  species = sim@params@species_params$species[!is.na(sim@params@A)],
  start_time = as.numeric(dimnames(sim@n)[[1]][1]),
  end_time = as.numeric(dimnames(sim@n)[[1]][dim(sim@n)[1]]), ylim = c(NA,
  NA), total = FALSE, ...)
}
\arguments{
\item{sim}{An object of class \linkS4class{MizerSim}}

\item{...}{Other arguments to pass to \code{getSBB} method, currently 
unused.}

\item{species}{Name or vector of names of the species to be plotted. By
default all species are plotted.}

\item{start_time}{The first time to be plotted. Default is the beginning
of the time series.}

\item{end_time}{The last time to be plotted. Default is the end of the
time series.}

\item{ylim}{A numeric vector of length two providing limits of for the
y axis. Use NA to refer to the existing minimum or maximum. Any values
below 1e-20 are always cut off.}

\item{total}{A boolean value that determines whether the total SSB from
all species is plotted as well. Default is FALSE}
}
\value{
A data frame that can be used in \code{\link{display_frames}}
}
\description{
After running a projection, the spawning stock biomass of each species can be
plotted against time.

Get the biomass frame from a \code{MizerSim} object.
}
\seealso{
\code{\link{getSSB}}
}
