---
title: "Benchmark"
date: "September 2, 2018"
output:
  html_document:
    theme: cosmo
    toc: true
    toc_float:
      collapsed: false
---

## Newton

```
benchmark_funco_all(hess_fd = TRUE, method = "newton", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, memory = 100, max_iter = 10000)
```

|             |            f|    nf|    ng|  iter|         ginf|          gr2|
|:------------|------------:|-----:|-----:|-----:|------------:|------------:|
|rosen        | 0.000000e+00|    32|    32|    24| 1.000000e-07| 1.000000e-07|
|freud_roth   | 4.898425e+01|    12|    12|     8| 0.000000e+00| 0.000000e+00|
|powell_bs    | 0.000000e+00|   124|   124|   100| 4.000000e-07| 4.000000e-07|
|brown_bs     | 0.000000e+00|    48|    48|     9| 0.000000e+00| 0.000000e+00|
|beale        | 0.000000e+00|    13|    13|     9| 1.000000e-07| 1.000000e-07|
|jenn_samp    | 1.243622e+02|    17|    17|    11| 0.000000e+00| 0.000000e+00|
|helical      | 0.000000e+00|    19|    19|    10| 1.000000e-06| 1.000000e-06|
|bard         | 8.214900e-03|    13|    13|     9| 1.000000e-07| 1.000000e-07|
|gauss        | 0.000000e+00|     3|     3|     2| 0.000000e+00| 0.000000e+00|
|meyer        | 2.922125e+06| 10145| 10145| 10000| 5.458442e+05| 6.804511e+05|
|gulf         | 0.000000e+00|  9168|  9168|  8967| 0.000000e+00| 0.000000e+00|
|box_3d       | 0.000000e+00|    20|    20|    13| 1.000000e-07| 1.000000e-07|
|powell_s     | 0.000000e+00|    22|    22|    18| 4.000000e-07| 5.000000e-07|
|wood         | 0.000000e+00|    52|    52|    42| 0.000000e+00| 0.000000e+00|
|kow_osb      | 3.075000e-04|  1204|  1204|  1168| 8.000000e-07| 9.000000e-07|
|brown_den    | 8.582220e+04|   463|   463|    32| 6.530000e-05| 7.120000e-05|
|osborne_1    | 1.139600e-03| 10138| 10138| 10000| 5.651170e-02| 9.696940e-02|
|biggs_exp6   | 7.034200e-03| 10155| 10155| 10000| 9.529000e-04| 1.229900e-03|
|osborne_2    | 4.013770e-02|  2575|  2575|  2532| 2.000000e-07| 2.000000e-07|
|watson       | 3.900000e-06| 10168| 10168| 10000| 4.165000e-04| 9.670000e-04|
|ex_rosen     | 0.000000e+00|    30|    30|    23| 0.000000e+00| 0.000000e+00|
|ex_powell    | 0.000000e+00|    23|    23|    18| 5.000000e-07| 1.600000e-06|
|penalty_1    | 2.025000e-04|    50|    50|    36| 5.000000e-07| 2.300000e-06|
|penalty_2    | 2.154560e-02|    43|    43|    33| 0.000000e+00| 0.000000e+00|
|var_dim      | 0.000000e+00|    46|    46|    12| 0.000000e+00| 0.000000e+00|
|trigon       | 5.700000e-06|    40|    40|    36| 0.000000e+00| 0.000000e+00|
|brown_al     | 4.543173e+03|   212|   212|    11| 7.173578e+02| 3.924835e+03|
|disc_bv      | 0.000000e+00|     7|     7|     6| 1.000000e-07| 2.000000e-07|
|disc_ie      | 0.000000e+00|    10|    10|     7| 0.000000e+00| 0.000000e+00|
|broyden_tri  | 0.000000e+00|     9|     9|     6| 2.000000e-07| 3.000000e-07|
|broyden_band | 0.000000e+00|    14|    14|     9| 0.000000e+00| 0.000000e+00|
|linfun_fr    | 5.500000e+01|     7|     7|     3| 3.000000e-07| 1.900000e-06|
|linfun_r1    | 2.462687e+01|    24|    24|     4| 4.000000e-07| 1.600000e-06|
|linfun_r1z   | 2.612690e+01|    27|    27|     6| 1.000000e-07| 2.000000e-07|
|chebyquad    | 5.386300e-03|  1569|  1569|  1485| 3.000000e-07| 6.000000e-07|

## Steepest Descent

|             |            f|    nf|    ng|  iter|         ginf|          gr2|
|:------------|------------:|-----:|-----:|-----:|------------:|------------:|
|rosen        | 0.000000e+00|  4292|  4292|  3827| 9.000000e-07| 1.000000e-06|
|freud_roth   | 4.898425e+01|   564|   564|   373| 1.400000e-06| 1.900000e-06|
|powell_bs    | 1.049790e-02| 10033| 10033| 10000| 2.376980e-02| 3.173140e-02|
|brown_bs     | 9.047199e+11| 10074| 10074| 10000| 1.902335e+06| 2.441482e+06|
|beale        | 0.000000e+00|   691|   691|   505| 1.000000e-06| 1.000000e-06|
|jenn_samp    | 1.243622e+02|   162|   162|    57| 1.088000e-04| 1.309000e-04|
|helical      | 0.000000e+00|  3017|  3017|  2592| 1.000000e-06| 1.000000e-06|
|bard         | 8.215300e-03| 10164| 10164| 10000| 7.050000e-05| 1.015000e-04|
|gauss        | 0.000000e+00|     6|     6|     2| 9.000000e-07| 9.000000e-07|
|meyer        | 6.966898e+06| 10040| 10040| 10000| 1.038433e+06| 1.455571e+06|
|gulf         | 4.839612e+00| 10028| 10028| 10000| 2.122943e-01| 2.657384e-01|
|box_3d       | 0.000000e+00|   251|   251|   119| 9.000000e-07| 1.300000e-06|
|powell_s     | 1.300000e-06| 10242| 10242| 10000| 1.988000e-04| 2.422000e-04|
|wood         | 0.000000e+00|  8449|  8449|  7704| 1.000000e-06| 1.300000e-06|
|kow_osb      | 3.075000e-04| 10174| 10174| 10000| 1.530000e-05| 1.960000e-05|
|brown_den    | 8.582220e+04|   259|   259|   106| 6.061000e-04| 7.469000e-04|
|osborne_1    | 2.680000e-04| 10155| 10155| 10000| 3.801690e-02| 4.834830e-02|
|biggs_exp6   | 6.205200e-03| 10856| 10856| 10000| 5.335000e-04| 8.717000e-04|
|osborne_2    | 4.031730e-02| 10051| 10051| 10000| 1.355800e-03| 1.795000e-03|
|watson       | 3.840000e-04| 10139| 10139| 10000| 4.017500e-03| 9.437300e-03|
|ex_rosen     | 0.000000e+00| 10710| 10710| 10000| 1.700000e-06| 5.500000e-06|
|ex_powell    | 7.200000e-06| 10216| 10216| 10000| 1.453000e-04| 4.597000e-04|
|penalty_1    | 2.026000e-04| 10037| 10037| 10000| 2.900000e-06| 7.600000e-06|
|penalty_2    | 2.154580e-02| 14119| 14119| 10000| 1.899000e-04| 1.908000e-04|
|var_dim      | 0.000000e+00|    47|    47|     7| 1.000000e-07| 4.000000e-07|
|trigon       | 5.700000e-06|   246|   246|   141| 9.000000e-07| 1.400000e-06|
|brown_al     | 4.000000e-07|    29|    29|     2| 4.914000e-04| 2.418800e-03|
|disc_bv      | 2.335700e-03| 10129| 10129| 10000| 9.537000e-04| 2.755800e-03|
|disc_ie      | 0.000000e+00|    27|    27|    10| 1.000000e-06| 1.200000e-06|
|broyden_tri  | 0.000000e+00|   153|   153|    75| 9.000000e-07| 3.300000e-06|
|broyden_band | 0.000000e+00|    63|    63|    26| 7.000000e-07| 9.000000e-07|
|linfun_fr    | 5.500000e+01|     8|     8|     2| 0.000000e+00| 0.000000e+00|
|linfun_r1    | 2.462687e+01|    25|    25|     3| 6.580000e-05| 2.592000e-04|
|linfun_r1z   | 2.612690e+01|    23|    23|     2| 1.000000e-07| 6.000000e-07|
|chebyquad    | 5.386300e-03| 10161| 10161| 10000| 5.410000e-05| 1.414000e-04|

## BFGS

```
benchmark_funco_all(method = "BFGS", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, memory = 5, 
max_iter = 10000)
```
|             |            f|  nf|  ng| iter|       ginf|        gr2|
|:------------|------------:|---:|---:|----:|----------:|----------:|
|rosen        | 0.000000e+00|  48|  48|   38|  0.0000006|  0.0000007|
|freud_roth   | 4.898425e+01|  27|  27|   22|  0.0000000|  0.0000000|
|powell_bs    | 0.000000e+00| 210| 210|  163|  0.0000006|  0.0000006|
|brown_bs     | 0.000000e+00|  39|  39|   16|  0.0000000|  0.0000000|
|beale        | 0.000000e+00|  21|  21|   19|  0.0000000|  0.0000000|
|jenn_samp    | 1.243622e+02|  71|  71|   27|  0.0000095|  0.0000131|
|helical      | 0.000000e+00|  40|  40|   32|  0.0000000|  0.0000000|
|bard         | 8.214900e-03|  38|  38|   35|  0.0000000|  0.0000000|
|gauss        | 0.000000e+00|   7|   7|    3|  0.0000000|  0.0000000|
|meyer        | 8.794586e+01| 599| 599|  446| 18.6943959| 18.6943963|
|gulf         | 0.000000e+00|  82|  82|   62|  0.0000000|  0.0000000|
|box_3d       | 0.000000e+00|  47|  47|   37|  0.0000010|  0.0000011|
|powell_s     | 0.000000e+00|  73|  73|   68|  0.0000003|  0.0000003|
|wood         | 0.000000e+00| 129| 129|  112|  0.0000000|  0.0000001|
|kow_osb      | 3.075000e-04|  43|  43|   37|  0.0000004|  0.0000005|
|brown_den    | 8.582220e+04| 111| 111|   43|  0.0000428|  0.0000451|
|osborne_1    | 5.460000e-05| 133| 133|  124|  0.0000003|  0.0000003|
|biggs_exp6   | 5.655600e-03|  56|  56|   51|  0.0000006|  0.0000010|
|osborne_2    | 4.013770e-02|  94|  94|   89|  0.0000001|  0.0000002|
|watson       | 0.000000e+00| 152| 152|  147|  0.0000003|  0.0000006|
|ex_rosen     | 0.000000e+00|  55|  55|   38|  0.0000000|  0.0000000|
|ex_powell    | 0.000000e+00|  69|  69|   64|  0.0000008|  0.0000019|
|penalty_1    | 2.025000e-04| 104| 104|   75|  0.0000000|  0.0000002|
|penalty_2    | 2.154560e-02| 569| 569|  537|  0.0000008|  0.0000018|
|var_dim      | 0.000000e+00|  45|  45|   29|  0.0000001|  0.0000003|
|trigon       | 5.700000e-06|  47|  47|   46|  0.0000006|  0.0000016|
|brown_al     | 0.000000e+00|  35|  35|   26|  0.0000001|  0.0000003|
|disc_bv      | 0.000000e+00| 131| 131|  130|  0.0000008|  0.0000030|
|disc_ie      | 0.000000e+00|  22|  22|   19|  0.0000003|  0.0000010|
|broyden_tri  | 0.000000e+00|  31|  31|   28|  0.0000008|  0.0000024|
|broyden_band | 0.000000e+00|  57|  57|   52|  0.0000009|  0.0000025|
|linfun_fr    | 5.500000e+01|   7|   7|    3|  0.0000000|  0.0000000|
|linfun_r1    | 2.462687e+01|  23|  23|    4|  0.0000003|  0.0000010|
|linfun_r1z   | 2.612690e+01|  23|  23|    4|  0.0000001|  0.0000005|
|chebyquad    | 5.386300e-03| 179| 179|  165|  0.0000007|  0.0000023|

## L-BFGS

### memory = 5

```
benchmark_funco_all(method = "L-BFGS", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, memory = 5, max_iter = 10000)
```
|             |            f|    nf|    ng| iter|      ginf|       gr2|
|:------------|------------:|-----:|-----:|----:|---------:|---------:|
|rosen        | 0.000000e+00|    51|    51|   39| 0.0000002| 0.0000003|
|freud_roth   | 4.898425e+01|    25|    25|   19| 0.0000000| 0.0000000|
|powell_bs    | 0.000000e+00|   236|   236|  174| 0.0000001| 0.0000001|
|brown_bs     | 0.000000e+00|    45|    45|   20| 0.0001648| 0.0001648|
|beale        | 0.000000e+00|    17|    17|   15| 0.0000005| 0.0000006|
|jenn_samp    | 1.243622e+02|    25|    25|   18| 0.0000008| 0.0000008|
|helical      | 0.000000e+00|    41|    41|   29| 0.0000002| 0.0000003|
|bard         | 8.214900e-03|    28|    28|   24| 0.0000002| 0.0000004|
|gauss        | 0.000000e+00|     7|     7|    3| 0.0000000| 0.0000000|
|meyer        | 8.794586e+01|   648|   648|  471| 0.1304093| 0.1304093|
|gulf         | 0.000000e+00|    80|    80|   62| 0.0000003| 0.0000003|
|box_3d       | 0.000000e+00|    42|    42|   30| 0.0000003| 0.0000003|
|powell_s     | 0.000000e+00|   107|   107|   88| 0.0000003| 0.0000003|
|wood         | 0.000000e+00|   129|   129|  105| 0.0000000| 0.0000000|
|kow_osb      | 3.075000e-04|    44|    44|   32| 0.0000001| 0.0000001|
|brown_den    | 8.582220e+04| 17576| 17576|  900| 0.0006688| 0.0007641|
|osborne_1    | 5.460000e-05|   285|   285|  239| 0.0000010| 0.0000015|
|biggs_exp6   | 5.655600e-03|    56|    56|   46| 0.0000000| 0.0000000|
|osborne_2    | 4.013770e-02|   251|   251|  241| 0.0000009| 0.0000019|
|watson       | 0.000000e+00|  1514|  1514| 1368| 0.0000010| 0.0000023|
|ex_rosen     | 0.000000e+00|    49|    49|   37| 0.0000010| 0.0000034|
|ex_powell    | 0.000000e+00|    74|    74|   62| 0.0000009| 0.0000021|
|penalty_1    | 2.025000e-04|    85|    85|   60| 0.0000004| 0.0000016|
|penalty_2    | 2.154560e-02|   463|   463|  369| 0.0000009| 0.0000013|
|var_dim      | 0.000000e+00|    45|    45|   29| 0.0000001| 0.0000003|
|trigon       | 5.700000e-06|    50|    50|   47| 0.0000008| 0.0000014|
|brown_al     | 0.000000e+00|    33|    33|   23| 0.0000006| 0.0000033|
|disc_bv      | 0.000000e+00|  1771|  1771| 1748| 0.0000006| 0.0000018|
|disc_ie      | 0.000000e+00|    13|    13|   10| 0.0000005| 0.0000019|
|broyden_tri  | 0.000000e+00|    32|    32|   28| 0.0000006| 0.0000017|
|broyden_band | 0.000000e+00|    23|    23|   18| 0.0000006| 0.0000010|
|linfun_fr    | 5.500000e+01|     7|     7|    3| 0.0000000| 0.0000000|
|linfun_r1    | 2.462687e+01|    23|    23|    4| 0.0000000| 0.0000002|
|linfun_r1z   | 2.612690e+01|    23|    23|    4| 0.0000001| 0.0000004|
|chebyquad    | 5.386300e-03|   416|   416|  395| 0.0000008| 0.0000025|

### memory = 20

```
benchmark_funco_all(method = "L-BFGS", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, memory = 20, 
max_iter = 10000)
```
|             |            f|  nf|  ng| iter|      ginf|       gr2|
|:------------|------------:|---:|---:|----:|---------:|---------:|
|rosen        | 0.000000e+00|  52|  52|   38| 0.0000000| 0.0000000|
|freud_roth   | 4.898425e+01|  27|  27|   22| 0.0000001| 0.0000001|
|powell_bs    | 0.000000e+00| 203| 203|  159| 0.0000003| 0.0000003|
|brown_bs     | 0.000000e+00|  39|  39|   16| 0.0000001| 0.0000001|
|beale        | 0.000000e+00|  18|  18|   16| 0.0000000| 0.0000000|
|jenn_samp    | 1.243622e+02|  26|  26|   19| 0.0000002| 0.0000003|
|helical      | 0.000000e+00|  39|  39|   29| 0.0000001| 0.0000001|
|bard         | 8.214900e-03|  31|  31|   26| 0.0000001| 0.0000001|
|gauss        | 0.000000e+00|   7|   7|    3| 0.0000000| 0.0000000|
|meyer        | 8.794586e+01| 629| 629|  445| 0.6301518| 0.6301518|
|gulf         | 0.000000e+00|  78|  78|   60| 0.0000001| 0.0000001|
|box_3d       | 0.000000e+00|  44|  44|   34| 0.0000004| 0.0000006|
|powell_s     | 0.000000e+00|  51|  51|   43| 0.0000008| 0.0000012|
|wood         | 0.000000e+00| 121| 121|   93| 0.0000006| 0.0000008|
|kow_osb      | 3.075000e-04|  33|  33|   26| 0.0000007| 0.0000009|
|brown_den    | 8.582220e+04| 435| 435|   44| 0.0000205| 0.0000208|
|osborne_1    | 5.460000e-05| 112| 112|  101| 0.0000009| 0.0000009|
|biggs_exp6   | 5.655600e-03|  51|  51|   46| 0.0000001| 0.0000001|
|osborne_2    | 4.013770e-02|  80|  80|   75| 0.0000004| 0.0000006|
|watson       | 0.000000e+00| 128| 128|  113| 0.0000004| 0.0000010|
|ex_rosen     | 0.000000e+00|  49|  49|   38| 0.0000002| 0.0000006|
|ex_powell    | 0.000000e+00|  44|  44|   38| 0.0000004| 0.0000013|
|penalty_1    | 2.025000e-04|  84|  84|   59| 0.0000005| 0.0000023|
|penalty_2    | 2.154560e-02| 244| 244|  216| 0.0000008| 0.0000018|
|var_dim      | 0.000000e+00|  45|  45|   29| 0.0000001| 0.0000003|
|trigon       | 5.700000e-06|  42|  42|   39| 0.0000006| 0.0000011|
|brown_al     | 0.000000e+00|  35|  35|   26| 0.0000001| 0.0000004|
|disc_bv      | 0.000000e+00| 633| 633|  625| 0.0000007| 0.0000020|
|disc_ie      | 0.000000e+00|  13|  13|   10| 0.0000007| 0.0000025|
|broyden_tri  | 0.000000e+00|  32|  32|   28| 0.0000002| 0.0000007|
|broyden_band | 0.000000e+00|  23|  23|   18| 0.0000005| 0.0000008|
|linfun_fr    | 5.500000e+01|   7|   7|    3| 0.0000000| 0.0000000|
|linfun_r1    | 2.462687e+01|  23|  23|    4| 0.0000000| 0.0000002|
|linfun_r1z   | 2.612690e+01|  23|  23|    4| 0.0000001| 0.0000004|
|chebyquad    | 5.386300e-03| 288| 288|  271| 0.0000009| 0.0000027|

Increasing the memory to 20 does seem to help.

### memory = 50

```
benchmark_funco_all(method = "L-BFGS", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, memory = 50, max_iter = 10000)
```

|             |            f|  nf|  ng| iter|      ginf|       gr2|
|:------------|------------:|---:|---:|----:|---------:|---------:|
|rosen        | 0.000000e+00|  52|  52|   38| 0.0000000| 0.0000000|
|freud_roth   | 4.898425e+01|  27|  27|   22| 0.0000001| 0.0000001|
|powell_bs    | 0.000000e+00| 214| 214|  165| 0.0000003| 0.0000003|
|brown_bs     | 0.000000e+00|  39|  39|   16| 0.0000001| 0.0000001|
|beale        | 0.000000e+00|  18|  18|   16| 0.0000000| 0.0000000|
|jenn_samp    | 1.243622e+02|  26|  26|   19| 0.0000002| 0.0000003|
|helical      | 0.000000e+00|  39|  39|   29| 0.0000000| 0.0000000|
|bard         | 8.214900e-03|  31|  31|   26| 0.0000001| 0.0000001|
|gauss        | 0.000000e+00|   7|   7|    3| 0.0000000| 0.0000000|
|meyer        | 8.794586e+01| 557| 557|  421| 0.5080988| 0.5080988|
|gulf         | 0.000000e+00|  75|  75|   59| 0.0000003| 0.0000003|
|box_3d       | 0.000000e+00|  41|  41|   33| 0.0000008| 0.0000011|
|powell_s     | 0.000000e+00|  52|  52|   48| 0.0000003| 0.0000003|
|wood         | 0.000000e+00| 127| 127|   96| 0.0000001| 0.0000001|
|kow_osb      | 3.075000e-04|  34|  34|   27| 0.0000009| 0.0000011|
|brown_den    | 8.582220e+04| 134| 134|   28| 0.0001229| 0.0001425|
|osborne_1    | 5.460000e-05|  95|  95|   88| 0.0000001| 0.0000002|
|biggs_exp6   | 5.655600e-03|  50|  50|   45| 0.0000001| 0.0000001|
|osborne_2    | 4.013770e-02|  76|  76|   71| 0.0000002| 0.0000003|
|watson       | 0.000000e+00| 108| 108|  100| 0.0000003| 0.0000006|
|ex_rosen     | 0.000000e+00|  49|  49|   38| 0.0000002| 0.0000006|
|ex_powell    | 0.000000e+00|  44|  44|   39| 0.0000003| 0.0000009|
|penalty_1    | 2.025000e-04|  84|  84|   59| 0.0000005| 0.0000023|
|penalty_2    | 2.154560e-02| 235| 235|  209| 0.0000008| 0.0000009|
|var_dim      | 0.000000e+00|  45|  45|   29| 0.0000001| 0.0000003|
|trigon       | 5.700000e-06|  42|  42|   40| 0.0000004| 0.0000007|
|brown_al     | 0.000000e+00|  35|  35|   26| 0.0000001| 0.0000004|
|disc_bv      | 0.000000e+00| 179| 179|  173| 0.0000005| 0.0000014|
|disc_ie      | 0.000000e+00|  13|  13|   10| 0.0000007| 0.0000025|
|broyden_tri  | 0.000000e+00|  32|  32|   28| 0.0000002| 0.0000007|
|broyden_band | 0.000000e+00|  23|  23|   18| 0.0000005| 0.0000008|
|linfun_fr    | 5.500000e+01|   7|   7|    3| 0.0000000| 0.0000000|
|linfun_r1    | 2.462687e+01|  23|  23|    4| 0.0000000| 0.0000002|
|linfun_r1z   | 2.612690e+01|  23|  23|    4| 0.0000001| 0.0000004|
|chebyquad    | 5.386300e-03| 192| 192|  174| 0.0000007| 0.0000019|

A further, but more moderate improvement.

### memory = 100

```
benchmark_funco_all(method = "L-BFGS", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, memory = 100, max_iter = 10000)
```

|             |            f|  nf|  ng| iter|       ginf|        gr2|
|:------------|------------:|---:|---:|----:|----------:|----------:|
|rosen        | 0.000000e+00|  52|  52|   38|  0.0000000|  0.0000000|
|freud_roth   | 4.898425e+01|  27|  27|   22|  0.0000001|  0.0000001|
|powell_bs    | 0.000000e+00| 207| 207|  164|  0.0000004|  0.0000004|
|brown_bs     | 0.000000e+00|  39|  39|   16|  0.0000001|  0.0000001|
|beale        | 0.000000e+00|  18|  18|   16|  0.0000000|  0.0000000|
|jenn_samp    | 1.243622e+02|  26|  26|   19|  0.0000002|  0.0000003|
|helical      | 0.000000e+00|  39|  39|   29|  0.0000000|  0.0000000|
|bard         | 8.214900e-03|  31|  31|   26|  0.0000001|  0.0000001|
|gauss        | 0.000000e+00|   7|   7|    3|  0.0000000|  0.0000000|
|meyer        | 8.794586e+01| 598| 598|  430| 62.7745094| 62.7745108|
|gulf         | 0.000000e+00|  75|  75|   59|  0.0000003|  0.0000003|
|box_3d       | 0.000000e+00|  41|  41|   33|  0.0000008|  0.0000011|
|powell_s     | 0.000000e+00|  52|  52|   48|  0.0000003|  0.0000003|
|wood         | 0.000000e+00| 127| 127|   97|  0.0000003|  0.0000003|
|kow_osb      | 3.075000e-04|  34|  34|   27|  0.0000009|  0.0000011|
|brown_den    | 8.582220e+04| 134| 134|   28|  0.0001229|  0.0001425|
|osborne_1    | 5.460000e-05|  96|  96|   89|  0.0000002|  0.0000002|
|biggs_exp6   | 5.655600e-03|  50|  50|   45|  0.0000001|  0.0000001|
|osborne_2    | 4.013770e-02|  75|  75|   70|  0.0000009|  0.0000016|
|watson       | 0.000000e+00|  96|  96|   90|  0.0000003|  0.0000006|
|ex_rosen     | 0.000000e+00|  49|  49|   38|  0.0000002|  0.0000006|
|ex_powell    | 0.000000e+00|  44|  44|   39|  0.0000003|  0.0000009|
|penalty_1    | 2.025000e-04|  84|  84|   59|  0.0000005|  0.0000023|
|penalty_2    | 2.154560e-02| 204| 204|  177|  0.0000006|  0.0000009|
|var_dim      | 0.000000e+00|  45|  45|   29|  0.0000001|  0.0000003|
|trigon       | 5.700000e-06|  42|  42|   40|  0.0000004|  0.0000007|
|brown_al     | 0.000000e+00|  35|  35|   26|  0.0000001|  0.0000004|
|disc_bv      | 0.000000e+00| 112| 112|  106|  0.0000001|  0.0000004|
|disc_ie      | 0.000000e+00|  13|  13|   10|  0.0000007|  0.0000025|
|broyden_tri  | 0.000000e+00|  32|  32|   28|  0.0000002|  0.0000007|
|broyden_band | 0.000000e+00|  23|  23|   18|  0.0000005|  0.0000008|
|linfun_fr    | 5.500000e+01|   7|   7|    3|  0.0000000|  0.0000000|
|linfun_r1    | 2.462687e+01|  23|  23|    4|  0.0000000|  0.0000002|
|linfun_r1z   | 2.612690e+01|  23|  23|    4|  0.0000001|  0.0000004|
|chebyquad    | 5.386300e-03| 166| 166|  149|  0.0000006|  0.0000013|

Diminishing returns for datasets of this size.

## Truncated Newton

### Curvature exit criterion

```
benchmark_funco_all(method = "tn", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, max_iter = 10000)
```

|             |            f|   nf|    ng| iter|        ginf|         gr2|
|:------------|------------:|----:|-----:|----:|-----------:|-----------:|
|rosen        | 0.000000e+00|   66|   146|   52|   0.0000000|   0.0000000|
|freud_roth   | 4.898425e+01|   23|    46|   15|   0.0000000|   0.0000000|
|powell_bs    | 4.000000e-07|  258|   486|  120|   0.0000010|   0.0000010|
|brown_bs     | 0.000000e+00|   42|    60|   10|   0.0000642|   0.0000642|
|beale        | 0.000000e+00|   15|    37|   13|   0.0000000|   0.0000000|
|jenn_samp    | 1.243622e+02|   17|    32|   11|   0.0000001|   0.0000001|
|helical      | 0.000000e+00|   26|    63|   17|   0.0000005|   0.0000006|
|bard         | 8.214900e-03|   16|    45|   14|   0.0000002|   0.0000002|
|gauss        | 0.000000e+00|    3|     6|    2|   0.0000000|   0.0000000|
|meyer        | 5.486069e+03|  919|  2047|  349| 286.9073296| 287.6956479|
|gulf         | 0.000000e+00| 4940| 12493| 4880|   0.0000000|   0.0000000|
|box_3d       | 0.000000e+00|   23|    53|   16|   0.0000000|   0.0000000|
|powell_s     | 0.000000e+00|   25|    92|   20|   0.0000008|   0.0000012|
|wood         | 0.000000e+00|  535|  2333|  488|   0.0000000|   0.0000000|
|kow_osb      | 3.075000e-04|   14|    52|   11|   0.0000000|   0.0000000|
|brown_den    | 8.582220e+04|   51|    89|   19|   0.0000008|   0.0000010|
|osborne_1    | 5.470000e-05|  163|   586|   90|   0.0000008|   0.0000010|
|biggs_exp6   | 5.655700e-03|   63|   233|   53|   0.0000005|   0.0000006|
|osborne_2    | 4.013770e-02|   44|   288|   35|   0.0000001|   0.0000001|
|watson       | 0.000000e+00|   33|   181|   25|   0.0000000|   0.0000000|
|ex_rosen     | 0.000000e+00|   93|   204|   72|   0.0000002|   0.0000007|
|ex_powell    | 0.000000e+00|   26|    91|   20|   0.0000007|   0.0000029|
|penalty_1    | 2.025000e-04|   53|   107|   38|   0.0000003|   0.0000008|
|penalty_2    | 2.154560e-02|   72|   318|   56|   0.0000009|   0.0000014|
|var_dim      | 0.000000e+00|   37|    58|   21|   0.0000000|   0.0000001|
|trigon       | 5.700000e-06|   20|   121|   12|   0.0000000|   0.0000000|
|brown_al     | 0.000000e+00|   17|    30|    8|   0.0000006|   0.0000031|
|disc_bv      | 0.000000e+00|   98|  3281|   91|   0.0000010|   0.0000024|
|disc_ie      | 0.000000e+00|   11|    22|    8|   0.0000000|   0.0000000|
|broyden_tri  | 0.000000e+00|   15|    48|   12|   0.0000001|   0.0000004|
|broyden_band | 0.000000e+00|   18|    43|   13|   0.0000000|   0.0000000|
|linfun_fr    | 5.500000e+01|    7|    10|    3|   0.0000000|   0.0000000|
|linfun_r1    | 2.462687e+01|   23|    27|    4|   0.0000000|   0.0000002|
|linfun_r1z   | 2.612690e+01|   23|    27|    4|   0.0000001|   0.0000004|
|chebyquad    | 5.386300e-03|   78|  2030|   71|   0.0000010|   0.0000033|

### Strong curvature exit criterion

```
benchmark_funco_all(method = "tn", tn_exit = "strong", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, max_iter = 10000)
```

|             |            f|   nf|    ng| iter|        ginf|         gr2|
|:------------|------------:|----:|-----:|----:|-----------:|-----------:|
|rosen        | 0.000000e+00|   66|   146|   52|   0.0000000|   0.0000000|
|freud_roth   | 4.898425e+01|   23|    46|   15|   0.0000000|   0.0000000|
|powell_bs    | 4.000000e-07|  258|   486|  120|   0.0000010|   0.0000010|
|brown_bs     | 0.000000e+00|   42|    60|   10|   0.0000642|   0.0000642|
|beale        | 0.000000e+00|   15|    37|   13|   0.0000000|   0.0000000|
|jenn_samp    | 1.243622e+02|   17|    32|   11|   0.0000001|   0.0000001|
|helical      | 0.000000e+00|   26|    63|   17|   0.0000005|   0.0000006|
|bard         | 8.214900e-03|   16|    45|   14|   0.0000002|   0.0000002|
|gauss        | 0.000000e+00|    3|     6|    2|   0.0000000|   0.0000000|
|meyer        | 1.185781e+03| 1199|  2644|  445| 110.3660443| 110.6963459|
|gulf         | 0.000000e+00| 4949| 12497| 4880|   0.0000000|   0.0000000|
|box_3d       | 0.000000e+00|   23|    53|   16|   0.0000000|   0.0000000|
|powell_s     | 0.000000e+00|   25|    92|   20|   0.0000008|   0.0000012|
|wood         | 0.000000e+00|  535|  2333|  488|   0.0000000|   0.0000000|
|kow_osb      | 3.075000e-04|   15|    57|   12|   0.0000000|   0.0000000|
|brown_den    | 8.582220e+04|   51|    89|   19|   0.0000008|   0.0000010|
|osborne_1    | 5.470000e-05|  202|   663|  104|   0.0000010|   0.0000011|
|biggs_exp6   | 5.655700e-03|   63|   233|   53|   0.0000005|   0.0000006|
|osborne_2    | 4.013770e-02|   44|   281|   35|   0.0000008|   0.0000011|
|watson       | 0.000000e+00|   34|   180|   26|   0.0000002|   0.0000004|
|ex_rosen     | 0.000000e+00|   93|   204|   72|   0.0000002|   0.0000007|
|ex_powell    | 0.000000e+00|   26|    90|   20|   0.0000008|   0.0000029|
|penalty_1    | 2.025000e-04|   53|   107|   38|   0.0000003|   0.0000008|
|penalty_2    | 2.154560e-02|   73|   358|   58|   0.0000008|   0.0000011|
|var_dim      | 0.000000e+00|   37|    58|   21|   0.0000000|   0.0000001|
|trigon       | 5.700000e-06|   20|   108|   12|   0.0000000|   0.0000001|
|brown_al     | 0.000000e+00|   17|    30|    8|   0.0000006|   0.0000031|
|disc_bv      | 0.000000e+00|   83|  2777|   78|   0.0000006|   0.0000018|
|disc_ie      | 0.000000e+00|   11|    22|    8|   0.0000000|   0.0000000|
|broyden_tri  | 0.000000e+00|   15|    48|   12|   0.0000001|   0.0000004|
|broyden_band | 0.000000e+00|   18|    43|   13|   0.0000000|   0.0000000|
|linfun_fr    | 5.500000e+01|    7|    10|    3|   0.0000000|   0.0000000|
|linfun_r1    | 2.462687e+01|   23|    27|    4|   0.0000000|   0.0000002|
|linfun_r1z   | 2.612690e+01|   23|    27|    4|   0.0000001|   0.0000004|
|chebyquad    | 5.386300e-03|   73|  1797|   68|   0.0000008|   0.0000021|

Strong exit sometimes does a lot better, sometimes a lot worse. Hard to 
decide if it's a winner.

### Initialize with previous vector

```
benchmark_funco_all(method = "tn", tn_init = "previous", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, max_iter = 10000)
```

|             |            f|    nf|     ng|  iter|         ginf|          gr2|
|:------------|------------:|-----:|------:|-----:|------------:|------------:|
|rosen        | 0.000000e+00|    49|    124|    33| 0.000000e+00| 0.000000e+00|
|freud_roth   | 4.898425e+01|    46|     77|    13| 0.000000e+00| 0.000000e+00|
|powell_bs    | 0.000000e+00|  1338|   3779|  1220| 4.826228e+00| 4.826228e+00|
|brown_bs     | 0.000000e+00|    40|     90|    14| 8.522438e+01| 8.522438e+01|
|beale        | 0.000000e+00|    26|     62|    15| 4.000000e-07| 5.000000e-07|
|jenn_samp    | 1.243622e+02|    58|     90|    13| 5.000000e-06| 6.200000e-06|
|helical      | 0.000000e+00|    37|     93|    19| 1.000000e-07| 2.000000e-07|
|bard         | 8.214900e-03|    14|     45|    11| 4.000000e-07| 4.000000e-07|
|gauss        | 0.000000e+00|     3|      7|     2| 0.000000e+00| 0.000000e+00|
|meyer        | 1.495379e+05| 10145| 139940| 10000| 8.237995e+04| 1.085280e+05|
|gulf         | 0.000000e+00|   105|    242|    59| 1.000000e-07| 1.000000e-07|
|box_3d       | 0.000000e+00|    23|     67|    15| 1.000000e-07| 1.000000e-07|
|powell_s     | 0.000000e+00|    27|    113|    21| 9.000000e-07| 1.000000e-06|
|wood         | 0.000000e+00|    78|    262|    59| 0.000000e+00| 0.000000e+00|
|kow_osb      | 3.075000e-04|    18|     70|    14| 1.000000e-07| 1.000000e-07|
|brown_den    | 8.582220e+04|    45|     94|    15| 1.630000e-05| 1.740000e-05|
|osborne_1    | 5.460000e-05|   233|    664|   134| 0.000000e+00| 0.000000e+00|
|biggs_exp6   | 5.655600e-03|    30|    121|    26| 2.000000e-07| 3.000000e-07|
|osborne_2    | 4.013770e-02|    87|    408|    56| 0.000000e+00| 0.000000e+00|
|watson       | 0.000000e+00|    31|    227|    27| 0.000000e+00| 1.000000e-07|
|ex_rosen     | 0.000000e+00|    64|    160|    41| 2.000000e-07| 6.000000e-07|
|ex_powell    | 0.000000e+00|    23|     98|    18| 9.000000e-07| 2.800000e-06|
|penalty_1    | 2.025000e-04|    48|    123|    34| 5.000000e-07| 2.200000e-06|
|penalty_2    | 2.154560e-02|   263|    675|   159| 6.000000e-07| 6.000000e-07|
|var_dim      | 0.000000e+00|    37|     78|    21| 4.000000e-07| 1.200000e-06|
|trigon       | 1.800000e-06|    26|    208|    14| 0.000000e+00| 0.000000e+00|
|brown_al     | 0.000000e+00|    18|     38|     8| 5.000000e-07| 2.800000e-06|
|disc_bv      | 0.000000e+00|    45|   1224|    36| 8.000000e-07| 2.100000e-06|
|disc_ie      | 0.000000e+00|    11|     33|     8| 1.000000e-07| 1.000000e-07|
|broyden_tri  | 0.000000e+00|    14|     80|    11| 0.000000e+00| 0.000000e+00|
|broyden_band | 0.000000e+00|    16|     54|    11| 8.000000e-07| 2.300000e-06|
|linfun_fr    | 5.500000e+01|     7|     12|     3| 0.000000e+00| 2.000000e-07|
|linfun_r1    | 2.462687e+01|    24|     33|     5| 1.000000e-07| 3.000000e-07|
|linfun_r1z   | 2.612690e+01|    24|     33|     5| 0.000000e+00| 1.000000e-07|
|chebyquad    | 5.386300e-03|    94|   2188|    62| 1.000000e-07| 5.000000e-07|

Doesn't seem to help at all.

### L-BFGS preconditioner (memory = 5)

```
benchmark_funco_all(method = "tn", preconditioner = "l-bfgs", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, max_iter = 10000)
```

|             |            f|  nf|   ng| iter|      ginf|       gr2|
|:------------|------------:|---:|----:|----:|---------:|---------:|
|rosen        | 0.000000e+00|  45|   92|   32| 0.0000000| 0.0000000|
|freud_roth   | 4.898425e+01|  15|   27|   10| 0.0000000| 0.0000000|
|powell_bs    | 0.000000e+00|  83|  188|   66| 0.0000001| 0.0000001|
|brown_bs     | 0.000000e+00|  43|   57|   11| 0.0000065| 0.0000065|
|beale        | 0.000000e+00|  13|   29|   11| 0.0000000| 0.0000000|
|jenn_samp    | 1.243622e+02|  18|   31|   12| 0.0000000| 0.0000000|
|helical      | 0.000000e+00|  26|   59|   19| 0.0000000| 0.0000000|
|bard         | 8.214900e-03|  15|   33|   12| 0.0000002| 0.0000002|
|gauss        | 0.000000e+00|   3|    6|    2| 0.0000000| 0.0000000|
|meyer        | 8.794586e+01| 507| 1064|  313| 5.0543225| 5.0543225|
|gulf         | 0.000000e+00|  24|   50|   17| 0.0000000| 0.0000000|
|box_3d       | 0.000000e+00|  23|   46|   16| 0.0000003| 0.0000003|
|powell_s     | 0.000000e+00|  24|   70|   19| 0.0000007| 0.0000009|
|wood         | 0.000000e+00| 103|  247|   71| 0.0000000| 0.0000000|
|kow_osb      | 3.075000e-04|  13|   45|   10| 0.0000000| 0.0000000|
|brown_den    | 8.582220e+04|  47|   70|   15| 0.0000150| 0.0000224|
|osborne_1    | 5.460000e-05|  57|  170|   45| 0.0000000| 0.0000000|
|biggs_exp6   | 5.655600e-03|  33|   89|   28| 0.0000000| 0.0000000|
|osborne_2    | 4.013770e-02|  31|  144|   27| 0.0000000| 0.0000000|
|watson       | 0.000000e+00|  21|   91|   18| 0.0000000| 0.0000001|
|ex_rosen     | 0.000000e+00|  43|   88|   29| 0.0000001| 0.0000005|
|ex_powell    | 0.000000e+00|  26|   71|   20| 0.0000007| 0.0000022|
|penalty_1    | 2.025000e-04|  52|  108|   37| 0.0000003| 0.0000013|
|penalty_2    | 2.154560e-02|  54|  203|   44| 0.0000000| 0.0000000|
|var_dim      | 0.000000e+00|  37|   58|   21| 0.0000000| 0.0000001|
|trigon       | 5.700000e-06|  18|   96|   11| 0.0000004| 0.0000007|
|brown_al     | 0.000000e+00|  17|   29|    8| 0.0000007| 0.0000036|
|disc_bv      | 0.000000e+00|  18|  387|   16| 0.0000000| 0.0000001|
|disc_ie      | 0.000000e+00|  11|   20|    8| 0.0000002| 0.0000004|
|broyden_tri  | 0.000000e+00|  14|   44|   11| 0.0000001| 0.0000003|
|broyden_band | 0.000000e+00|  17|   33|   12| 0.0000001| 0.0000004|
|linfun_fr    | 5.500000e+01|   7|   10|    3| 0.0000000| 0.0000000|
|linfun_r1    | 2.462687e+01|  23|   27|    4| 0.0000001| 0.0000003|
|linfun_r1z   | 2.612690e+01|  23|   27|    4| 0.0000001| 0.0000004|
|chebyquad    | 5.386300e-03|  32|  413|   23| 0.0000009| 0.0000025|

L-BFGS preconditioning seems to be a big help.

### Strong exit + L-BFGS preconditioner (memory = 5)

```
benchmark_funco_all(method = "tn", tn_exit = "strong", preconditioner = "l-bfgs", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, max_iter = 10000)
```

|             |            f|  nf|   ng| iter|      ginf|       gr2|
|:------------|------------:|---:|----:|----:|---------:|---------:|
|rosen        | 0.000000e+00|  45|   92|   32| 0.0000000| 0.0000000|
|freud_roth   | 4.898425e+01|  15|   27|   10| 0.0000000| 0.0000000|
|powell_bs    | 0.000000e+00|  83|  188|   66| 0.0000001| 0.0000001|
|brown_bs     | 0.000000e+00|  43|   57|   11| 0.0000065| 0.0000065|
|beale        | 0.000000e+00|  13|   29|   11| 0.0000000| 0.0000000|
|jenn_samp    | 1.243622e+02|  18|   31|   12| 0.0000000| 0.0000000|
|helical      | 0.000000e+00|  26|   59|   19| 0.0000000| 0.0000000|
|bard         | 8.214900e-03|  15|   33|   12| 0.0000002| 0.0000002|
|gauss        | 0.000000e+00|   3|    6|    2| 0.0000000| 0.0000000|
|meyer        | 8.794586e+01| 505| 1032|  306| 0.0053488| 0.0053488|
|gulf         | 0.000000e+00|  24|   50|   17| 0.0000000| 0.0000000|
|box_3d       | 0.000000e+00|  23|   46|   16| 0.0000003| 0.0000003|
|powell_s     | 0.000000e+00|  24|   70|   19| 0.0000007| 0.0000009|
|wood         | 0.000000e+00| 103|  247|   71| 0.0000000| 0.0000000|
|kow_osb      | 3.075000e-04|  13|   45|   10| 0.0000000| 0.0000000|
|brown_den    | 8.582220e+04|  47|   70|   15| 0.0000150| 0.0000224|
|osborne_1    | 5.460000e-05|  57|  167|   45| 0.0000001| 0.0000001|
|biggs_exp6   | 5.655600e-03|  33|   89|   28| 0.0000000| 0.0000000|
|osborne_2    | 4.013770e-02|  31|  144|   27| 0.0000000| 0.0000000|
|watson       | 0.000000e+00|  22|   95|   19| 0.0000004| 0.0000007|
|ex_rosen     | 0.000000e+00|  43|   88|   29| 0.0000001| 0.0000005|
|ex_powell    | 0.000000e+00|  26|   71|   20| 0.0000007| 0.0000022|
|penalty_1    | 2.025000e-04|  52|  108|   37| 0.0000003| 0.0000013|
|penalty_2    | 2.154560e-02|  65|  235|   54| 0.0000002| 0.0000002|
|var_dim      | 0.000000e+00|  37|   58|   21| 0.0000000| 0.0000001|
|trigon       | 5.700000e-06|  18|   91|   11| 0.0000007| 0.0000020|
|brown_al     | 0.000000e+00|  17|   29|    8| 0.0000007| 0.0000036|
|disc_bv      | 0.000000e+00|  18|  370|   16| 0.0000002| 0.0000004|
|disc_ie      | 0.000000e+00|  11|   20|    8| 0.0000002| 0.0000004|
|broyden_tri  | 0.000000e+00|  14|   44|   11| 0.0000001| 0.0000003|
|broyden_band | 0.000000e+00|  17|   33|   12| 0.0000001| 0.0000004|
|linfun_fr    | 5.500000e+01|   7|   10|    3| 0.0000000| 0.0000000|
|linfun_r1    | 2.462687e+01|  23|   27|    4| 0.0000001| 0.0000003|
|linfun_r1z   | 2.612690e+01|  23|   27|    4| 0.0000001| 0.0000004|
|chebyquad    | 5.386300e-03|  31|  392|   23| 0.0000004| 0.0000011|

Strong exit helps more than it hinders here.

### L-BFGS preconditioner (memory = 20)

```
benchmark_funco_all(method = "tn", preconditioner = "l-bfgs", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, max_iter = 10000, memory = 20)
```

|             |            f|  nf|   ng| iter|     ginf|      gr2|
|:------------|------------:|---:|----:|----:|--------:|--------:|
|rosen        | 0.000000e+00|  44|   90|   32| 1.00e-07| 1.00e-07|
|freud_roth   | 4.898425e+01|  15|   27|   10| 0.00e+00| 0.00e+00|
|powell_bs    | 0.000000e+00|  79|  176|   63| 1.00e-07| 1.00e-07|
|brown_bs     | 0.000000e+00|  43|   57|   11| 6.50e-06| 6.50e-06|
|beale        | 0.000000e+00|  13|   29|   11| 0.00e+00| 0.00e+00|
|jenn_samp    | 1.243622e+02|  18|   31|   12| 0.00e+00| 0.00e+00|
|helical      | 0.000000e+00|  24|   56|   17| 6.00e-07| 8.00e-07|
|bard         | 8.214900e-03|  15|   32|   12| 2.00e-07| 3.00e-07|
|gauss        | 0.000000e+00|   3|    6|    2| 0.00e+00| 0.00e+00|
|meyer        | 8.794586e+01| 463| 1007|  321| 1.25e-04| 1.25e-04|
|gulf         | 0.000000e+00|  24|   50|   17| 0.00e+00| 0.00e+00|
|box_3d       | 0.000000e+00|  21|   41|   14| 0.00e+00| 0.00e+00|
|powell_s     | 0.000000e+00|  24|   67|   19| 4.00e-07| 6.00e-07|
|wood         | 0.000000e+00|  99|  254|   81| 0.00e+00| 0.00e+00|
|kow_osb      | 3.075000e-04|  13|   45|   10| 0.00e+00| 0.00e+00|
|brown_den    | 8.582220e+04|  24|   47|   13| 0.00e+00| 0.00e+00|
|osborne_1    | 5.460000e-05|  56|  147|   45| 0.00e+00| 0.00e+00|
|biggs_exp6   | 5.655600e-03|  47|  117|   41| 0.00e+00| 0.00e+00|
|osborne_2    | 4.013770e-02|  36|  128|   28| 0.00e+00| 0.00e+00|
|watson       | 0.000000e+00|  20|   62|   18| 6.00e-07| 1.40e-06|
|ex_rosen     | 0.000000e+00|  43|   88|   29| 1.00e-07| 5.00e-07|
|ex_powell    | 0.000000e+00|  25|   73|   19| 4.00e-07| 1.30e-06|
|penalty_1    | 2.025000e-04|  52|  108|   37| 3.00e-07| 1.30e-06|
|penalty_2    | 2.154560e-02|  52|  170|   42| 1.00e-07| 4.00e-07|
|var_dim      | 0.000000e+00|  37|   58|   21| 0.00e+00| 1.00e-07|
|trigon       | 5.700000e-06|  18|   99|   11| 1.00e-07| 1.00e-07|
|brown_al     | 0.000000e+00|  17|   29|    8| 7.00e-07| 3.60e-06|
|disc_bv      | 0.000000e+00|  16|  323|   15| 8.00e-07| 1.20e-06|
|disc_ie      | 0.000000e+00|  11|   20|    8| 2.00e-07| 4.00e-07|
|broyden_tri  | 0.000000e+00|  14|   43|   11| 1.00e-07| 4.00e-07|
|broyden_band | 0.000000e+00|  17|   33|   12| 2.00e-07| 3.00e-07|
|linfun_fr    | 5.500000e+01|   7|   10|    3| 0.00e+00| 0.00e+00|
|linfun_r1    | 2.462687e+01|  23|   27|    4| 1.00e-07| 3.00e-07|
|linfun_r1z   | 2.612690e+01|  23|   27|    4| 1.00e-07| 4.00e-07|
|chebyquad    | 5.386300e-03|  35|  550|   27| 3.00e-07| 8.00e-07|

Increasing the memory to 20 seems to help (although not on chebyquad).

### Strong curvature and L-BFGS preconditioner (memory = 20)

```
benchmark_funco_all(method = "tn", preconditioner = "l-bfgs", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, max_iter = 10000, memory = 20)
```

|             |            f|  nf|   ng| iter|     ginf|      gr2|
|:------------|------------:|---:|----:|----:|--------:|--------:|
|rosen        | 0.000000e+00|  44|   90|   32| 1.00e-07| 1.00e-07|
|freud_roth   | 4.898425e+01|  15|   27|   10| 0.00e+00| 0.00e+00|
|powell_bs    | 0.000000e+00|  79|  176|   63| 1.00e-07| 1.00e-07|
|brown_bs     | 0.000000e+00|  43|   57|   11| 6.50e-06| 6.50e-06|
|beale        | 0.000000e+00|  13|   29|   11| 0.00e+00| 0.00e+00|
|jenn_samp    | 1.243622e+02|  18|   31|   12| 0.00e+00| 0.00e+00|
|helical      | 0.000000e+00|  24|   56|   17| 6.00e-07| 8.00e-07|
|bard         | 8.214900e-03|  15|   32|   12| 2.00e-07| 3.00e-07|
|gauss        | 0.000000e+00|   3|    6|    2| 0.00e+00| 0.00e+00|
|meyer        | 8.794586e+01| 463| 1007|  321| 1.25e-04| 1.25e-04|
|gulf         | 0.000000e+00|  24|   50|   17| 0.00e+00| 0.00e+00|
|box_3d       | 0.000000e+00|  21|   41|   14| 0.00e+00| 0.00e+00|
|powell_s     | 0.000000e+00|  24|   67|   19| 4.00e-07| 6.00e-07|
|wood         | 0.000000e+00|  99|  254|   81| 0.00e+00| 0.00e+00|
|kow_osb      | 3.075000e-04|  13|   45|   10| 0.00e+00| 0.00e+00|
|brown_den    | 8.582220e+04|  24|   47|   13| 0.00e+00| 0.00e+00|
|osborne_1    | 5.460000e-05|  56|  147|   45| 0.00e+00| 0.00e+00|
|biggs_exp6   | 5.655600e-03|  47|  117|   41| 0.00e+00| 0.00e+00|
|osborne_2    | 4.013770e-02|  36|  128|   28| 0.00e+00| 0.00e+00|
|watson       | 0.000000e+00|  20|   62|   18| 6.00e-07| 1.40e-06|
|ex_rosen     | 0.000000e+00|  43|   88|   29| 1.00e-07| 5.00e-07|
|ex_powell    | 0.000000e+00|  25|   73|   19| 4.00e-07| 1.30e-06|
|penalty_1    | 2.025000e-04|  52|  108|   37| 3.00e-07| 1.30e-06|
|penalty_2    | 2.154560e-02|  62|  214|   50| 5.00e-07| 5.00e-07|
|var_dim      | 0.000000e+00|  37|   58|   21| 0.00e+00| 1.00e-07|
|trigon       | 5.700000e-06|  18|   95|   11| 1.00e-07| 3.00e-07|
|brown_al     | 0.000000e+00|  17|   29|    8| 7.00e-07| 3.60e-06|
|disc_bv      | 0.000000e+00|  17|  345|   16| 1.00e-07| 1.00e-07|
|disc_ie      | 0.000000e+00|  11|   20|    8| 2.00e-07| 4.00e-07|
|broyden_tri  | 0.000000e+00|  14|   43|   11| 1.00e-07| 4.00e-07|
|broyden_band | 0.000000e+00|  17|   33|   12| 2.00e-07| 3.00e-07|
|linfun_fr    | 5.500000e+01|   7|   10|    3| 0.00e+00| 0.00e+00|
|linfun_r1    | 2.462687e+01|  23|   27|    4| 1.00e-07| 3.00e-07|
|linfun_r1z   | 2.612690e+01|  23|   27|    4| 1.00e-07| 4.00e-07|
|chebyquad    | 5.386300e-03|  36|  537|   28| 2.00e-07| 4.00e-07|

Again strong curvature exit criterion doesn't make a strong case. 

## Conjugate Gradient

## Hestenes-Stiefel

|             |            f|    nf|    ng|  iter|        ginf|         gr2|
|:------------|------------:|-----:|-----:|-----:|-----------:|-----------:|
|rosen        | 0.000000e+00|    70|    70|    24|   0.0000003|   0.0000003|
|freud_roth   | 4.898425e+01|    25|    25|    10|   0.0000002|   0.0000002|
|powell_bs    | 0.000000e+00|   310|   310|    99|   0.0000003|   0.0000003|
|brown_bs     | 0.000000e+00|    57|    57|    12|   0.0000000|   0.0000000|
|beale        | 0.000000e+00|    28|    28|    10|   0.0000006|   0.0000006|
|jenn_samp    | 1.243622e+02|    47|    47|    12|   0.0000005|   0.0000005|
|helical      | 0.000000e+00|   135|   135|    58|   0.0000008|   0.0000011|
|bard         | 8.214900e-03|    75|    75|    28|   0.0000009|   0.0000010|
|gauss        | 0.000000e+00|     6|     6|     2|   0.0000004|   0.0000005|
|meyer        | 1.101692e+05| 24810| 24810| 10000| 144.7020770| 191.6132680|
|gulf         | 0.000000e+00|  1773|  1773|   805|   0.0000009|   0.0000011|
|box_3d       | 0.000000e+00|   150|   150|    66|   0.0000009|   0.0000013|
|powell_s     | 0.000000e+00|   161|   161|    71|   0.0000008|   0.0000010|
|wood         | 0.000000e+00|   149|   149|    66|   0.0000008|   0.0000012|
|kow_osb      | 3.075000e-04|   137|   137|    65|   0.0000009|   0.0000013|
|brown_den    | 8.582220e+04|   461|   461|    61|   0.0010604|   0.0012037|
|osborne_1    | 5.470000e-05|  8294|  8294|  3771|   0.0000008|   0.0000014|
|biggs_exp6   | 5.655700e-03|   536|   536|   245|   0.0000007|   0.0000010|
|osborne_2    | 4.013770e-02|   674|   674|   348|   0.0000007|   0.0000012|
|watson       | 0.000000e+00|  4506|  4506|  2107|   0.0000008|   0.0000014|
|ex_rosen     | 0.000000e+00|    70|    70|    24|   0.0000003|   0.0000010|
|ex_powell    | 0.000000e+00|   101|   101|    41|   0.0000009|   0.0000022|
|penalty_1    | 2.025000e-04|   195|   195|    43|   0.0000000|   0.0000002|
|penalty_2    | 2.154560e-02|  8212|  8212|  3983|   0.0000010|   0.0000029|
|var_dim      | 0.000000e+00|    56|    56|     8|   0.0000000|   0.0000000|
|trigon       | 5.700000e-06|    99|    99|    47|   0.0000010|   0.0000027|
|brown_al     | 4.000000e-07|    29|    29|     2|   0.0004914|   0.0024188|
|disc_bv      | 0.000000e+00|  2482|  2482|  1374|   0.0000008|   0.0000022|
|disc_ie      | 0.000000e+00|    23|    23|     8|   0.0000001|   0.0000003|
|broyden_tri  | 0.000000e+00|    63|    63|    30|   0.0000006|   0.0000019|
|broyden_band | 0.000000e+00|    77|    77|    27|   0.0000002|   0.0000004|
|linfun_fr    | 5.552666e+01|     6|     6|     2|   0.2163662|   1.4514283|
|linfun_r1    | 2.462687e+01|    25|    25|     3|   0.0000105|   0.0000413|
|linfun_r1z   | 2.612690e+01|    25|    25|     3|   0.0000451|   0.0001758|
|chebyquad    | 5.386300e-03|   620|   620|   318|   0.0000008|   0.0000017|

A near univeral improvement over steepest descent, ignoring `meyer`, anyway.

### Hestenes-Stiefel+

|             |            f|   nf|   ng| iter|       ginf|        gr2|
|:------------|------------:|----:|----:|----:|----------:|----------:|
|rosen        | 0.000000e+00|   70|   70|   24|  0.0000000|  0.0000000|
|freud_roth   | 4.898425e+01|   33|   33|   10|  0.0000000|  0.0000000|
|powell_bs    | 2.000000e-07|  129|  129|   43|  0.0000005|  0.0000005|
|brown_bs     | 0.000000e+00|   46|   46|   10|  0.0000165|  0.0000165|
|beale        | 0.000000e+00|   30|   30|   10|  0.0000009|  0.0000009|
|jenn_samp    | 1.243622e+02|   64|   64|   14|  0.0000079|  0.0000094|
|helical      | 0.000000e+00|  131|  131|   56|  0.0000000|  0.0000000|
|bard         | 8.214900e-03|   51|   51|   16|  0.0000000|  0.0000000|
|gauss        | 0.000000e+00|    6|    6|    2|  0.0000004|  0.0000005|
|meyer        | 1.011785e+04| 3283| 3283|  910| 60.6473720| 66.6025877|
|gulf         | 0.000000e+00|  692|  692|  307|  0.0000000|  0.0000000|
|box_3d       | 0.000000e+00|   45|   45|   15|  0.0000004|  0.0000005|
|powell_s     | 0.000000e+00|  398|  398|  181|  0.0000002|  0.0000002|
|wood         | 0.000000e+00|  149|  149|   66|  0.0000008|  0.0000012|
|kow_osb      | 3.075000e-04|   94|   94|   37|  0.0000003|  0.0000003|
|brown_den    | 8.582220e+04|  279|  279|   32|  0.0000622|  0.0000792|
|osborne_1    | 5.460000e-05| 1755| 1755|  725|  0.0000010|  0.0000012|
|biggs_exp6   | 5.655600e-03|  558|  558|  246|  0.0000003|  0.0000005|
|osborne_2    | 4.013770e-02|  674|  674|  348|  0.0000007|  0.0000012|
|watson       | 0.000000e+00| 2148| 2148| 1005|  0.0000009|  0.0000016|
|ex_rosen     | 0.000000e+00|   73|   73|   24|  0.0000000|  0.0000000|
|ex_powell    | 0.000000e+00|  113|  113|   45|  0.0000000|  0.0000001|
|penalty_1    | 2.025000e-04|  183|  183|   35|  0.0000005|  0.0000014|
|penalty_2    | 2.154560e-02|  595|  595|  225|  0.0000005|  0.0000008|
|var_dim      | 0.000000e+00|   47|   47|    8|  0.0000000|  0.0000001|
|trigon       | 5.700000e-06|   99|   99|   47|  0.0000010|  0.0000027|
|brown_al     | 4.000000e-07|   29|   29|    2|  0.0004914|  0.0024188|
|disc_bv      | 0.000000e+00| 2482| 2482| 1374|  0.0000008|  0.0000022|
|disc_ie      | 0.000000e+00|   23|   23|    8|  0.0000001|  0.0000003|
|broyden_tri  | 0.000000e+00|   63|   63|   30|  0.0000006|  0.0000019|
|broyden_band | 0.000000e+00|   71|   71|   25|  0.0000007|  0.0000017|
|linfun_fr    | 5.500000e+01|    8|    8|    2|  0.0000000|  0.0000000|
|linfun_r1    | 2.462687e+01|   23|   23|    3|  0.0000658|  0.0002592|
|linfun_r1z   | 2.612690e+01|   23|   23|    2|  0.0000001|  0.0000006|
|chebyquad    | 5.386300e-03|  596|  596|  320|  0.0000008|  0.0000021|

HS+ is an improvement over HS.

### Fletcher-Reeves

|             |            f|    nf|    ng|  iter|         ginf|          gr2|
|:------------|------------:|-----:|-----:|-----:|------------:|------------:|
|rosen        | 0.000000e+00|   130|   130|    61| 5.000000e-07| 7.000000e-07|
|freud_roth   | 4.898425e+01|   167|   167|    35| 3.500000e-06| 3.600000e-06|
|powell_bs    | 3.500000e-06|   245|   245|    76| 1.270000e-05| 1.460000e-05|
|brown_bs     | 3.431072e+07| 18704| 18704| 10000| 2.350758e+06| 2.350787e+06|
|beale        | 0.000000e+00|   105|   105|    49| 3.000000e-07| 4.000000e-07|
|jenn_samp    | 1.243622e+02|   126|   126|    37| 7.500000e-06| 9.600000e-06|
|helical      | 0.000000e+00|   130|   130|    55| 9.000000e-07| 1.000000e-06|
|bard         | 8.214900e-03|   131|   131|    54| 9.000000e-07| 1.100000e-06|
|gauss        | 0.000000e+00|     6|     6|     2| 4.000000e-07| 4.000000e-07|
|meyer        | 1.106637e+04|   625|   625|   315| 2.224976e+02| 2.293460e+02|
|gulf         | 0.000000e+00|  1574|  1574|   793| 6.000000e-07| 7.000000e-07|
|box_3d       | 0.000000e+00|  7102|  7102|  3947| 1.000000e-06| 1.300000e-06|
|powell_s     | 0.000000e+00|  3617|  3617|  1836| 9.000000e-07| 1.200000e-06|
|wood         | 0.000000e+00|  1270|  1270|   661| 8.000000e-07| 9.000000e-07|
|kow_osb      | 3.075000e-04|   924|   924|   464| 1.000000e-06| 1.500000e-06|
|brown_den    | 8.582220e+04|   135|   135|    40| 3.642000e-04| 5.251000e-04|
|osborne_1    | 5.460000e-05| 10037| 10037|  4977| 1.900000e-06| 1.900000e-06|
|biggs_exp6   | 5.655700e-03|   724|   724|   352| 1.000000e-06| 1.700000e-06|
|osborne_2    | 4.013770e-02| 14777| 14777| 10000| 1.330000e-05| 1.960000e-05|
|watson       | 0.000000e+00|  2184|  2184|  1074| 7.000000e-07| 1.500000e-06|
|ex_rosen     | 0.000000e+00|   153|   153|    70| 8.000000e-07| 2.800000e-06|
|ex_powell    | 0.000000e+00|  1436|  1436|   730| 1.000000e-06| 3.500000e-06|
|penalty_1    | 2.025000e-04|    78|    78|    25| 1.000000e-07| 1.000000e-07|
|penalty_2    | 2.154560e-02|  2784|  2784|  1601| 1.000000e-06| 1.000000e-06|
|var_dim      | 0.000000e+00|    47|    47|     7| 1.000000e-07| 4.000000e-07|
|trigon       | 5.700000e-06|   539|   539|   360| 1.000000e-06| 2.300000e-06|
|brown_al     | 4.000000e-07|    29|    29|     2| 4.914000e-04| 2.418800e-03|
|disc_bv      | 0.000000e+00|  2347|  2347|  1328| 9.000000e-07| 2.700000e-06|
|disc_ie      | 0.000000e+00|    25|    25|     9| 8.000000e-07| 2.000000e-06|
|broyden_tri  | 0.000000e+00|    59|    59|    28| 1.000000e-06| 2.200000e-06|
|broyden_band | 0.000000e+00|    43|    43|    16| 2.000000e-07| 7.000000e-07|
|linfun_fr    | 5.500000e+01|     8|     8|     2| 0.000000e+00| 0.000000e+00|
|linfun_r1    | 2.462687e+01|    25|    25|     3| 2.320000e-05| 9.120000e-05|
|linfun_r1z   | 2.612690e+01|    25|    25|     3| 1.900000e-06| 7.400000e-06|
|chebyquad    | 5.413700e-03| 12770| 12770| 10000| 4.508890e-02| 1.086379e-01|

One of the weaker performing CG methods.

### Polak-Ribiere

|             |            f|    nf|    ng|  iter|         ginf|          gr2|
|:------------|------------:|-----:|-----:|-----:|------------:|------------:|
|rosen        | 0.000000e+00|    68|    68|    24| 3.000000e-07| 3.000000e-07|
|freud_roth   | 4.898425e+01|    37|    37|    14| 1.000000e-07| 1.000000e-07|
|powell_bs    | 0.000000e+00|   310|   310|   107| 1.000000e-07| 1.000000e-07|
|brown_bs     | 0.000000e+00|    78|    78|    16| 1.248000e-04| 1.248000e-04|
|beale        | 0.000000e+00|    32|    32|    11| 4.000000e-07| 4.000000e-07|
|jenn_samp    | 1.243622e+02|   103|   103|    17| 5.400000e-06| 7.300000e-06|
|helical      | 0.000000e+00|   167|   167|    77| 0.000000e+00| 0.000000e+00|
|bard         | 8.214900e-03|   134|   134|    60| 4.000000e-07| 6.000000e-07|
|gauss        | 0.000000e+00|     6|     6|     2| 4.000000e-07| 5.000000e-07|
|meyer        | 7.011330e+04| 23235| 23235| 10000| 1.893624e+04| 2.415847e+04|
|gulf         | 0.000000e+00|   353|   353|   143| 7.000000e-07| 7.000000e-07|
|box_3d       | 0.000000e+00|   104|   104|    40| 2.000000e-07| 2.000000e-07|
|powell_s     | 0.000000e+00|   276|   276|   117| 1.000000e-06| 1.400000e-06|
|wood         | 0.000000e+00|   135|   135|    55| 1.000000e-06| 1.400000e-06|
|kow_osb      | 3.075000e-04|   265|   265|   123| 2.000000e-07| 3.000000e-07|
|brown_den    | 8.582220e+04|   155|   155|    34| 3.180000e-04| 3.447000e-04|
|osborne_1    | 5.460000e-05|  7298|  7298|  3183| 3.000000e-07| 5.000000e-07|
|biggs_exp6   | 5.655700e-03|   409|   409|   192| 7.000000e-07| 1.300000e-06|
|osborne_2    | 4.013770e-02|   567|   567|   296| 7.000000e-07| 1.100000e-06|
|watson       | 0.000000e+00|  5953|  5953|  2728| 1.000000e-06| 2.300000e-06|
|ex_rosen     | 0.000000e+00|    71|    71|    24| 4.000000e-07| 1.700000e-06|
|ex_powell    | 0.000000e+00|   180|   180|    82| 5.000000e-07| 1.500000e-06|
|penalty_1    | 2.025000e-04|   101|   101|    24| 7.000000e-07| 3.000000e-06|
|penalty_2    | 2.154560e-02|  2166|  2166|   992| 1.000000e-06| 2.000000e-06|
|var_dim      | 0.000000e+00|    47|    47|     7| 1.000000e-07| 4.000000e-07|
|trigon       | 5.700000e-06|    99|    99|    46| 9.000000e-07| 2.300000e-06|
|brown_al     | 4.000000e-07|    29|    29|     2| 4.914000e-04| 2.418800e-03|
|disc_bv      | 0.000000e+00|  3491|  3491|  2001| 1.000000e-06| 2.900000e-06|
|disc_ie      | 0.000000e+00|    23|    23|     8| 1.000000e-07| 2.000000e-07|
|broyden_tri  | 0.000000e+00|    61|    61|    29| 9.000000e-07| 3.500000e-06|
|broyden_band | 0.000000e+00|    76|    76|    28| 4.000000e-07| 1.100000e-06|
|linfun_fr    | 5.500000e+01|     8|     8|     2| 0.000000e+00| 0.000000e+00|
|linfun_r1    | 2.462687e+01|    25|    25|     3| 2.312000e-04| 9.103000e-04|
|linfun_r1z   | 2.612690e+01|    23|    23|     2| 1.000000e-06| 3.800000e-06|
|chebyquad    | 5.386300e-03|   715|   715|   376| 9.000000e-07| 2.600000e-06|

Slightly better than HS, but not HS+.

### Polak-Ribiere+

|             |            f|   nf|   ng| iter|        ginf|         gr2|
|:------------|------------:|----:|----:|----:|-----------:|-----------:|
|rosen        | 0.000000e+00|   71|   71|   23|   0.0000002|   0.0000002|
|freud_roth   | 4.898425e+01|   42|   42|   14|   0.0000002|   0.0000002|
|powell_bs    | 3.000000e-07|  111|  111|   38|   0.0000006|   0.0000006|
|brown_bs     | 0.000000e+00|   70|   70|   16|   0.0000000|   0.0000000|
|beale        | 0.000000e+00|   32|   32|   11|   0.0000004|   0.0000004|
|jenn_samp    | 1.243622e+02|   49|   49|   14|   0.0000000|   0.0000000|
|helical      | 0.000000e+00|  167|  167|   77|   0.0000000|   0.0000000|
|bard         | 8.214900e-03|   76|   76|   30|   0.0000005|   0.0000005|
|gauss        | 0.000000e+00|    6|    6|    2|   0.0000004|   0.0000005|
|meyer        | 6.641666e+04|  823|  823|  163| 105.0484211| 142.2658645|
|gulf         | 0.000000e+00|  356|  356|  115|   0.0000005|   0.0000008|
|box_3d       | 0.000000e+00|   86|   86|   33|   0.0000005|   0.0000005|
|powell_s     | 0.000000e+00|  264|  264|  111|   0.0000010|   0.0000013|
|wood         | 0.000000e+00|  135|  135|   55|   0.0000010|   0.0000014|
|kow_osb      | 3.075000e-04|  107|  107|   43|   0.0000002|   0.0000003|
|brown_den    | 8.582220e+04|  386|  386|   47|   0.0001035|   0.0001197|
|osborne_1    | 5.470000e-05| 2473| 2473|  939|   0.0000009|   0.0000010|
|biggs_exp6   | 5.655700e-03|  338|  338|  142|   0.0000007|   0.0000011|
|osborne_2    | 4.013770e-02|  567|  567|  296|   0.0000007|   0.0000011|
|watson       | 0.000000e+00| 2987| 2987| 1324|   0.0000009|   0.0000020|
|ex_rosen     | 0.000000e+00|   71|   71|   24|   0.0000000|   0.0000001|
|ex_powell    | 0.000000e+00|  135|  135|   57|   0.0000003|   0.0000009|
|penalty_1    | 2.025000e-04|   97|   97|   26|   0.0000002|   0.0000007|
|penalty_2    | 2.154560e-02|  637|  637|  242|   0.0000009|   0.0000010|
|var_dim      | 0.000000e+00|   47|   47|    7|   0.0000001|   0.0000004|
|trigon       | 5.700000e-06|   99|   99|   46|   0.0000009|   0.0000023|
|brown_al     | 4.000000e-07|   29|   29|    2|   0.0004914|   0.0024188|
|disc_bv      | 0.000000e+00| 3491| 3491| 2001|   0.0000010|   0.0000029|
|disc_ie      | 0.000000e+00|   23|   23|    8|   0.0000001|   0.0000002|
|broyden_tri  | 0.000000e+00|   61|   61|   29|   0.0000009|   0.0000035|
|broyden_band | 0.000000e+00|   78|   78|   28|   0.0000002|   0.0000003|
|linfun_fr    | 5.500000e+01|    8|    8|    2|   0.0000000|   0.0000000|
|linfun_r1    | 2.462687e+01|   25|   25|    3|   0.0000658|   0.0002592|
|linfun_r1z   | 2.612690e+01|   23|   23|    2|   0.0000001|   0.0000006|
|chebyquad    | 5.386300e-03|  715|  715|  376|   0.0000009|   0.0000026|

PR+ improves on PR similarly to HS and HS+: normally it makes things better, and
when it doesn't, the effect is rarely large. HS+ seems to do a bit better 
though.

### Conjugate Descent (Fletcher)

|             |            f|    nf|    ng|  iter|        ginf|         gr2|
|:------------|------------:|-----:|-----:|-----:|-----------:|-----------:|
|rosen        | 0.000000e+00|   170|   170|    80|   0.0000001|   0.0000001|
|freud_roth   | 4.898425e+01|    62|    62|    22|   0.0000002|   0.0000002|
|powell_bs    | 4.400000e-06|   350|   350|   114|   0.0000094|   0.0000094|
|brown_bs     | 1.329342e+01|  1332|  1332|   613|   7.2920294|   7.2927602|
|beale        | 0.000000e+00|    67|    67|    28|   0.0000010|   0.0000012|
|jenn_samp    | 1.243622e+02|   126|   126|    37|   0.0000256|   0.0000257|
|helical      | 0.000000e+00|   246|   246|   114|   0.0000003|   0.0000004|
|bard         | 8.214900e-03|   172|   172|    78|   0.0000009|   0.0000009|
|gauss        | 0.000000e+00|     6|     6|     2|   0.0000004|   0.0000004|
|meyer        | 1.789903e+04|  1007|  1007|   426| 137.2600547| 152.3061786|
|gulf         | 0.000000e+00|  1607|  1607|   807|   0.0000006|   0.0000007|
|box_3d       | 0.000000e+00|  2923|  2923|  1580|   0.0000010|   0.0000010|
|powell_s     | 0.000000e+00|  1393|  1393|   714|   0.0000010|   0.0000010|
|wood         | 0.000000e+00|  1415|  1415|   734|   0.0000008|   0.0000011|
|kow_osb      | 3.075000e-04|   315|   315|   149|   0.0000010|   0.0000015|
|brown_den    | 8.582220e+04|   161|   161|    35|   0.0002232|   0.0002483|
|osborne_1    | 5.470000e-05|  5926|  5926|  2773|   0.0000007|   0.0000010|
|biggs_exp6   | 5.655700e-03|   365|   365|   177|   0.0000009|   0.0000018|
|osborne_2    | 4.815380e-02| 12837| 12837| 10000|   0.0561947|   0.1042313|
|watson       | 0.000000e+00| 13093| 13093|  6761|   0.0000010|   0.0000030|
|ex_rosen     | 0.000000e+00|   166|   166|    74|   0.0000003|   0.0000008|
|ex_powell    | 0.000000e+00|  1175|  1175|   621|   0.0000010|   0.0000022|
|penalty_1    | 2.025000e-04|    82|    82|    25|   0.0000002|   0.0000005|
|penalty_2    | 2.154560e-02|   359|   359|   136|   0.0000008|   0.0000017|
|var_dim      | 0.000000e+00|    47|    47|     7|   0.0000001|   0.0000004|
|trigon       | 1.630000e-05|  3692|  3692|  3031|   0.0018179|   0.0037987|
|brown_al     | 4.000000e-07|    29|    29|     2|   0.0004914|   0.0024188|
|disc_bv      | 0.000000e+00|  2467|  2467|  1387|   0.0000009|   0.0000027|
|disc_ie      | 0.000000e+00|    25|    25|     9|   0.0000007|   0.0000020|
|broyden_tri  | 0.000000e+00|    59|    59|    28|   0.0000010|   0.0000022|
|broyden_band | 0.000000e+00|    43|    43|    16|   0.0000004|   0.0000009|
|linfun_fr    | 5.500000e+01|     8|     8|     2|   0.0000000|   0.0000000|
|linfun_r1    | 2.462687e+01|    25|    25|     3|   0.0000232|   0.0000912|
|linfun_r1z   | 2.612690e+01|    25|    25|     3|   0.0000019|   0.0000074|
|chebyquad    | 5.386300e-03|  3930|  3930|  2647|   0.0000009|   0.0000024|

Out-performed by the previous methods.

### Liu-Storey

|             |            f|    nf|    ng|  iter|         ginf|          gr2|
|:------------|------------:|-----:|-----:|-----:|------------:|------------:|
|rosen        | 0.000000e+00|    67|    67|    21|    0.0000003|    0.0000003|
|freud_roth   | 4.898425e+01|    34|    34|     9|    0.0000001|    0.0000001|
|powell_bs    | 0.000000e+00|   325|   325|   105|    0.0000006|    0.0000006|
|brown_bs     | 0.000000e+00|    57|    57|    15|    0.0000000|    0.0000000|
|beale        | 0.000000e+00|    33|    33|    12|    0.0000000|    0.0000000|
|jenn_samp    | 1.243622e+02|    53|    53|    14|    0.0000001|    0.0000001|
|helical      | 0.000000e+00|   133|   133|    57|    0.0000003|    0.0000005|
|bard         | 8.214900e-03|    65|    65|    26|    0.0000004|    0.0000005|
|gauss        | 0.000000e+00|     6|     6|     2|    0.0000004|    0.0000005|
|meyer        | 1.121202e+05| 20212| 20212| 10000| 6875.7280040| 8381.5463828|
|gulf         | 0.000000e+00|  3617|  3617|  1783|    0.0000009|    0.0000013|
|box_3d       | 0.000000e+00|   127|   127|    54|    0.0000004|    0.0000005|
|powell_s     | 0.000000e+00|   583|   583|   259|    0.0000008|    0.0000011|
|wood         | 0.000000e+00|   164|   164|    75|    0.0000006|    0.0000008|
|kow_osb      | 3.075000e-04|   297|   297|   134|    0.0000007|    0.0000012|
|brown_den    | 8.582220e+04|  1068|  1068|   130|    0.0004317|    0.0004619|
|osborne_1    | 5.470000e-05|  4672|  4672|  2100|    0.0000008|    0.0000015|
|biggs_exp6   | 5.655700e-03|  1059|  1059|   487|    0.0000006|    0.0000012|
|osborne_2    | 4.013770e-02|   439|   439|   223|    0.0000008|    0.0000012|
|watson       | 0.000000e+00| 10753| 10753|  5039|    0.0000007|    0.0000014|
|ex_rosen     | 0.000000e+00|    82|    82|    23|    0.0000000|    0.0000000|
|ex_powell    | 0.000000e+00|   608|   608|   274|    0.0000006|    0.0000018|
|penalty_1    | 2.025000e-04|   108|   108|    26|    0.0000001|    0.0000003|
|penalty_2    | 2.154560e-02|  4204|  4204|  1708|    0.0000008|    0.0000016|
|var_dim      | 0.000000e+00|    47|    47|     7|    0.0000001|    0.0000004|
|trigon       | 5.700000e-06|    90|    90|    42|    0.0000007|    0.0000018|
|brown_al     | 4.000000e-07|    29|    29|     2|    0.0004914|    0.0024188|
|disc_bv      | 0.000000e+00|  3048|  3048|  1712|    0.0000009|    0.0000024|
|disc_ie      | 0.000000e+00|    23|    23|     8|    0.0000001|    0.0000002|
|broyden_tri  | 0.000000e+00|    63|    63|    30|    0.0000006|    0.0000018|
|broyden_band | 0.000000e+00|    72|    72|    26|    0.0000002|    0.0000007|
|linfun_fr    | 5.500000e+01|     8|     8|     2|    0.0000000|    0.0000000|
|linfun_r1    | 2.462687e+01|    25|    25|     3|    0.0002312|    0.0009103|
|linfun_r1z   | 2.612690e+01|    23|    23|     2|    0.0000010|    0.0000038|
|chebyquad    | 5.386300e-03|   730|   730|   381|    0.0000007|    0.0000019|

Does a better job than CD (and FR).

### PR-FR (Gilbert-Nocedal)

|             |            f|    nf|    ng|  iter|         ginf|          gr2|
|:------------|------------:|-----:|-----:|-----:|------------:|------------:|
|rosen        | 0.000000e+00|   266|   266|   119| 9.000000e-07| 1.300000e-06|
|freud_roth   | 4.898425e+01|    49|    49|    17| 9.000000e-07| 9.000000e-07|
|powell_bs    | 2.500000e-06| 19084| 19084| 10000| 2.634040e-02| 2.634040e-02|
|brown_bs     | 1.042116e+03| 19016| 19016| 10000| 4.899763e+03| 4.900188e+03|
|beale        | 0.000000e+00|   129|   129|    62| 5.000000e-07| 5.000000e-07|
|jenn_samp    | 1.243622e+02|   126|   126|    37| 7.500000e-06| 9.600000e-06|
|helical      | 0.000000e+00|   231|   231|   110| 9.000000e-07| 9.000000e-07|
|bard         | 8.214900e-03|    85|    85|    37| 8.000000e-07| 9.000000e-07|
|gauss        | 0.000000e+00|     6|     6|     2| 4.000000e-07| 4.000000e-07|
|meyer        | 1.145564e+04| 18644| 18644| 10000| 6.210160e+06| 6.210162e+06|
|gulf         | 0.000000e+00|   951|   951|   403| 7.000000e-07| 1.000000e-06|
|box_3d       | 0.000000e+00|   102|   102|    44| 5.000000e-07| 7.000000e-07|
|powell_s     | 0.000000e+00|  1583|  1583|   804| 5.000000e-07| 6.000000e-07|
|wood         | 0.000000e+00|   284|   284|   122| 7.000000e-07| 9.000000e-07|
|kow_osb      | 3.075000e-04|   377|   377|   174| 6.000000e-07| 8.000000e-07|
|brown_den    | 8.582220e+04|   150|   150|    58| 8.244000e-04| 8.740000e-04|
|osborne_1    | 5.470000e-05|  5491|  5491|  2689| 4.000000e-07| 5.000000e-07|
|biggs_exp6   | 5.655700e-03|   623|   623|   280| 6.000000e-07| 1.100000e-06|
|osborne_2    | 4.013770e-02|   483|   483|   246| 6.000000e-07| 1.100000e-06|
|watson       | 0.000000e+00|  3179|  3179|  1594| 6.000000e-07| 1.600000e-06|
|ex_rosen     | 0.000000e+00|   187|   187|    75| 5.000000e-07| 2.100000e-06|
|ex_powell    | 0.000000e+00|  1728|  1728|   885| 9.000000e-07| 2.800000e-06|
|penalty_1    | 2.025000e-04|   101|   101|    24| 3.000000e-07| 1.000000e-06|
|penalty_2    | 2.154560e-02|   424|   424|   141| 8.000000e-07| 1.600000e-06|
|var_dim      | 0.000000e+00|    47|    47|     7| 1.000000e-07| 4.000000e-07|
|trigon       | 5.700000e-06|   100|   100|    47| 9.000000e-07| 2.100000e-06|
|brown_al     | 4.000000e-07|    29|    29|     2| 4.914000e-04| 2.418800e-03|
|disc_bv      | 0.000000e+00|  2114|  2114|  1177| 1.000000e-06| 3.100000e-06|
|disc_ie      | 0.000000e+00|    23|    23|     8| 0.000000e+00| 1.000000e-07|
|broyden_tri  | 0.000000e+00|    59|    59|    28| 8.000000e-07| 1.800000e-06|
|broyden_band | 0.000000e+00|    41|    41|    15| 8.000000e-07| 2.200000e-06|
|linfun_fr    | 5.500000e+01|     8|     8|     2| 0.000000e+00| 0.000000e+00|
|linfun_r1    | 2.462687e+01|    25|    25|     3| 2.312000e-04| 9.103000e-04|
|linfun_r1z   | 2.612690e+01|    23|    23|     2| 1.000000e-06| 3.800000e-06|
|chebyquad    | 5.386300e-03|   615|   615|   323| 1.000000e-06| 2.600000e-06|

As noted by Hager and Zhang in their CG review, this doesn't perform as well
as PR or PR+ (which was introduced in the same paper). It's better than CD and
FR.

### Dai-Yuan

|             |            f|    nf|    ng|  iter|         ginf|          gr2|
|:------------|------------:|-----:|-----:|-----:|------------:|------------:|
|rosen        | 0.000000e+00|   152|   152|    74| 9.000000e-07| 1.000000e-06|
|freud_roth   | 4.898425e+01|    74|    74|    27| 8.000000e-07| 8.000000e-07|
|powell_bs    | 1.600000e-06| 13995| 13995|  7248| 2.540000e-05| 2.560000e-05|
|brown_bs     | 3.317837e+06| 18781| 18781| 10000| 1.191937e+06| 1.191942e+06|
|beale        | 0.000000e+00|   107|   107|    50| 7.000000e-07| 7.000000e-07|
|jenn_samp    | 1.243622e+02|   142|   142|    36| 4.990000e-05| 6.030000e-05|
|helical      | 0.000000e+00|   233|   233|   110| 5.000000e-07| 8.000000e-07|
|bard         | 8.214900e-03|   180|   180|    83| 8.000000e-07| 1.200000e-06|
|gauss        | 0.000000e+00|     6|     6|     2| 4.000000e-07| 4.000000e-07|
|meyer        | 1.159679e+04|   506|   506|   307| 1.600562e+02| 1.635501e+02|
|gulf         | 0.000000e+00|   893|   893|   436| 1.000000e-06| 1.100000e-06|
|box_3d       | 0.000000e+00|    85|    85|    34| 3.000000e-07| 4.000000e-07|
|powell_s     | 0.000000e+00|  3595|  3595|  2139| 1.000000e-06| 1.000000e-06|
|wood         | 0.000000e+00| 10202| 10202|  9915| 9.000000e-07| 1.500000e-06|
|kow_osb      | 3.075000e-04|   730|   730|   355| 1.000000e-06| 1.300000e-06|
|brown_den    | 8.582220e+04|   151|   151|    56| 1.465000e-04| 1.725000e-04|
|osborne_1    | 5.460000e-05|  1466|  1466|   621| 8.000000e-07| 1.200000e-06|
|biggs_exp6   | 5.655600e-03|   606|   606|   291| 7.000000e-07| 1.300000e-06|
|osborne_2    | 4.013770e-02| 10441| 10441| 10000| 6.300000e-05| 1.151000e-04|
|watson       | 0.000000e+00|  2363|  2363|  1161| 6.000000e-07| 1.000000e-06|
|ex_rosen     | 0.000000e+00|   146|   146|    69| 0.000000e+00| 1.000000e-07|
|ex_powell    | 0.000000e+00|  3960|  3960|  2397| 1.000000e-06| 2.200000e-06|
|penalty_1    | 2.025000e-04|    74|    74|    26| 9.000000e-07| 4.300000e-06|
|penalty_2    | 2.154560e-02|  3172|  3172|  1862| 1.000000e-06| 1.000000e-06|
|var_dim      | 0.000000e+00|    47|    47|     7| 1.000000e-07| 4.000000e-07|
|trigon       | 5.700000e-06|   423|   423|   326| 1.000000e-06| 2.300000e-06|
|brown_al     | 4.000000e-07|    29|    29|     2| 4.914000e-04| 2.418800e-03|
|disc_bv      | 0.000000e+00|  1554|  1554|   853| 9.000000e-07| 2.800000e-06|
|disc_ie      | 0.000000e+00|    25|    25|     9| 8.000000e-07| 2.300000e-06|
|broyden_tri  | 0.000000e+00|    59|    59|    28| 1.000000e-06| 2.200000e-06|
|broyden_band | 0.000000e+00|    43|    43|    16| 3.000000e-07| 7.000000e-07|
|linfun_fr    | 5.500000e+01|     8|     8|     2| 0.000000e+00| 0.000000e+00|
|linfun_r1    | 2.462687e+01|    25|    25|     3| 1.410000e-05| 5.570000e-05|
|linfun_r1z   | 2.612690e+01|    23|    23|     2| 1.000000e-07| 3.000000e-07|
|chebyquad    | 5.408700e-03| 10033| 10033| 10000| 3.929020e-02| 8.725480e-02|

Performs about as well as CD or FR.

### Hager-Zhang

|             |            f|    nf|    ng|  iter|         ginf|          gr2|
|:------------|------------:|-----:|-----:|-----:|------------:|------------:|
|rosen        | 0.000000e+00|    75|    75|    24| 9.000000e-07| 9.000000e-07|
|freud_roth   | 4.898425e+01|    92|    92|    13| 1.100000e-06| 1.100000e-06|
|powell_bs    | 0.000000e+00|   308|   308|   104| 1.000000e-07| 1.000000e-07|
|brown_bs     | 0.000000e+00|    64|    64|    17| 0.000000e+00| 0.000000e+00|
|beale        | 0.000000e+00|    43|    43|    15| 0.000000e+00| 0.000000e+00|
|jenn_samp    | 1.243622e+02|    40|    40|    13| 0.000000e+00| 0.000000e+00|
|helical      | 0.000000e+00|   207|   207|    98| 8.000000e-07| 1.300000e-06|
|bard         | 8.214900e-03|    87|    87|    36| 1.000000e-07| 2.000000e-07|
|gauss        | 0.000000e+00|     6|     6|     2| 4.000000e-07| 4.000000e-07|
|meyer        | 1.117394e+05| 25912| 25912| 10000| 1.563419e+04| 1.884501e+04|
|gulf         | 0.000000e+00|   868|   868|   348| 9.000000e-07| 1.500000e-06|
|box_3d       | 0.000000e+00|    95|    95|    36| 3.000000e-07| 3.000000e-07|
|powell_s     | 0.000000e+00|   289|   289|   126| 9.000000e-07| 1.200000e-06|
|wood         | 0.000000e+00|   714|   714|   356| 1.000000e-06| 1.200000e-06|
|kow_osb      | 3.075000e-04|   179|   179|    81| 7.000000e-07| 9.000000e-07|
|brown_den    | 8.582220e+04|  1056|  1056|   136| 8.700000e-06| 1.220000e-05|
|osborne_1    | 5.460000e-05|  6134|  6134|  2688| 5.000000e-07| 6.000000e-07|
|biggs_exp6   | 5.655700e-03|   490|   490|   230| 2.000000e-07| 3.000000e-07|
|osborne_2    | 4.013770e-02|   520|   520|   266| 5.000000e-07| 8.000000e-07|
|watson       | 0.000000e+00|  9602|  9602|  4517| 7.000000e-07| 1.500000e-06|
|ex_rosen     | 0.000000e+00|    72|    72|    27| 0.000000e+00| 0.000000e+00|
|ex_powell    | 0.000000e+00|   265|   265|   111| 8.000000e-07| 2.800000e-06|
|penalty_1    | 2.025000e-04|   108|   108|    28| 5.000000e-07| 2.600000e-06|
|penalty_2    | 2.154560e-02|  8243|  8243|  4002| 9.000000e-07| 2.100000e-06|
|var_dim      | 0.000000e+00|    47|    47|     7| 1.000000e-07| 4.000000e-07|
|trigon       | 5.700000e-06|    90|    90|    45| 1.000000e-06| 1.800000e-06|
|brown_al     | 4.000000e-07|    29|    29|     2| 4.914000e-04| 2.418800e-03|
|disc_bv      | 0.000000e+00|  3504|  3504|  2005| 9.000000e-07| 2.600000e-06|
|disc_ie      | 0.000000e+00|    22|    22|     8| 9.000000e-07| 1.700000e-06|
|broyden_tri  | 0.000000e+00|    63|    63|    30| 8.000000e-07| 2.000000e-06|
|broyden_band | 0.000000e+00|    44|    44|    16| 4.000000e-07| 9.000000e-07|
|linfun_fr    | 5.500000e+01|     8|     8|     2| 0.000000e+00| 0.000000e+00|
|linfun_r1    | 2.462687e+01|    23|    23|     2| 9.000000e-07| 3.500000e-06|
|linfun_r1z   | 2.612690e+01|    25|    25|     3| 4.200000e-05| 1.634000e-04|
|chebyquad    | 5.386300e-03|   725|   725|   382| 9.000000e-07| 3.200000e-06|

Outperformed by HS, PR and their + variants.

### Hager-Zhang+

|             |            f|    nf|    ng| iter|        ginf|         gr2|
|:------------|------------:|-----:|-----:|----:|-----------:|-----------:|
|rosen        | 0.000000e+00|    75|    75|   26|   0.0000000|   0.0000000|
|freud_roth   | 4.898425e+01|    40|    40|   12|   0.0000001|   0.0000001|
|powell_bs    | 2.000000e-07|   117|   117|   35|   0.0000004|   0.0000004|
|brown_bs     | 0.000000e+00|    67|    67|   12|   0.0004226|   0.0004226|
|beale        | 0.000000e+00|    43|    43|   15|   0.0000000|   0.0000000|
|jenn_samp    | 1.243622e+02|    39|    39|   11|   0.0000009|   0.0000010|
|helical      | 0.000000e+00|   120|   120|   53|   0.0000008|   0.0000011|
|bard         | 8.214900e-03|    92|    92|   37|   0.0000001|   0.0000002|
|gauss        | 0.000000e+00|     6|     6|    2|   0.0000004|   0.0000004|
|meyer        | 7.044739e+04| 16603| 16603| 6975| 101.5292162| 129.2218041|
|gulf         | 0.000000e+00|  2974|  2974| 1459|   0.0000010|   0.0000015|
|box_3d       | 0.000000e+00|    43|    43|   13|   0.0000000|   0.0000000|
|powell_s     | 0.000000e+00|   289|   289|  126|   0.0000009|   0.0000012|
|wood         | 0.000000e+00|   604|   604|  304|   0.0000009|   0.0000011|
|kow_osb      | 3.075000e-04|   179|   179|   81|   0.0000007|   0.0000009|
|brown_den    | 8.582220e+04|  1056|  1056|  136|   0.0000087|   0.0000122|
|osborne_1    | 5.470000e-05|  7366|  7366| 3255|   0.0000008|   0.0000011|
|biggs_exp6   | 5.655700e-03|   244|   244|  104|   0.0000007|   0.0000010|
|osborne_2    | 4.013770e-02|   520|   520|  266|   0.0000005|   0.0000008|
|watson       | 0.000000e+00|  3490|  3490| 1636|   0.0000008|   0.0000017|
|ex_rosen     | 0.000000e+00|    77|    77|   25|   0.0000010|   0.0000034|
|ex_powell    | 0.000000e+00|   265|   265|  111|   0.0000008|   0.0000028|
|penalty_1    | 2.025000e-04|   108|   108|   28|   0.0000005|   0.0000026|
|penalty_2    | 2.154560e-02|  8243|  8243| 4002|   0.0000009|   0.0000021|
|var_dim      | 0.000000e+00|    47|    47|    7|   0.0000001|   0.0000004|
|trigon       | 5.700000e-06|    90|    90|   45|   0.0000010|   0.0000018|
|brown_al     | 4.000000e-07|    29|    29|    2|   0.0004914|   0.0024188|
|disc_bv      | 0.000000e+00|  3504|  3504| 2005|   0.0000009|   0.0000026|
|disc_ie      | 0.000000e+00|    22|    22|    8|   0.0000009|   0.0000017|
|broyden_tri  | 0.000000e+00|    63|    63|   30|   0.0000008|   0.0000020|
|broyden_band | 0.000000e+00|    43|    43|   16|   0.0000007|   0.0000012|
|linfun_fr    | 5.500000e+01|     8|     8|    2|   0.0000000|   0.0000000|
|linfun_r1    | 2.462687e+01|    23|    23|    2|   0.0000009|   0.0000035|
|linfun_r1z   | 2.612690e+01|    25|    25|    3|   0.0000420|   0.0001634|
|chebyquad    | 5.386300e-03|   725|   725|  382|   0.0000009|   0.0000032|

Does about as well as PR and HS, but PR+ and HS+ do better. I am surprised.

### Preconditioned FR (memory = 5)

|             |            f|    nf|    ng|  iter|         ginf|          gr2|
|:------------|------------:|-----:|-----:|-----:|------------:|------------:|
|rosen        | 0.000000e+00|   209|   209|   109| 1.000000e-06| 1.200000e-06|
|freud_roth   | 4.898425e+01|   826|   826|   549| 4.300000e-06| 4.400000e-06|
|powell_bs    | 0.000000e+00|  5046|  5046|  2725| 1.674000e-04| 1.674000e-04|
|brown_bs     | 4.944243e+11| 11812| 11812| 10000| 4.396293e+09| 4.396293e+09|
|beale        | 0.000000e+00|    57|    57|    21| 3.000000e-07| 3.000000e-07|
|jenn_samp    | 1.264918e+02| 11455| 11455| 10000| 4.348597e+02| 6.072054e+02|
|helical      | 5.768740e+00| 12732| 12732| 10000| 4.973227e+01| 5.085210e+01|
|bard         | 8.214900e-03|  5181|  5181|  3071| 7.000000e-07| 7.000000e-07|
|gauss        | 0.000000e+00|     8|     8|     3| 0.000000e+00| 0.000000e+00|
|meyer        | 6.977345e+06|    66|    66|     8| 1.022989e+06| 1.039608e+06|
|gulf         | 0.000000e+00|  7359|  7359|  5565| 1.000000e-07| 1.000000e-07|
|box_3d       | 0.000000e+00|  1447|  1447|  1108| 1.000000e-07| 1.000000e-07|
|powell_s     | 0.000000e+00| 16113| 16113| 10000| 4.000000e-05| 5.650000e-05|
|wood         | 1.499122e+01| 12000| 12000| 10000| 7.089859e+01| 7.594090e+01|
|kow_osb      | 3.075000e-04| 15250| 15250| 10000| 2.068000e-04| 2.375000e-04|
|brown_den    | 2.725599e+06| 10960| 10960| 10000| 2.056073e+05| 3.020291e+05|
|osborne_1    | 1.549337e-01| 11563| 11563| 10000| 5.920879e+00| 6.786782e+00|
|biggs_exp6   | 5.655700e-03| 16962| 16962| 10000| 1.680000e-05| 2.410000e-05|
|osborne_2    | 4.013770e-02|  4304|  4304|  2506| 9.000000e-07| 1.400000e-06|
|watson       | 3.200000e-06| 14289| 14289| 10000| 9.924000e-04| 2.809200e-03|
|ex_rosen     | 0.000000e+00|   136|   136|    48| 2.000000e-07| 7.000000e-07|
|ex_powell    | 0.000000e+00|   416|   416|   232| 4.000000e-07| 1.100000e-06|
|penalty_1    | 2.025000e-04|   111|   111|    29| 1.000000e-07| 6.000000e-07|
|penalty_2    | 2.154580e-02|  8311|  8311|  5485| 1.577000e-04| 1.625000e-04|
|var_dim      | 0.000000e+00|    47|    47|     7| 1.000000e-07| 4.000000e-07|
|trigon       | 5.700000e-06|   103|   103|    53| 7.000000e-07| 1.300000e-06|
|brown_al     | 4.000000e-07|    29|    29|     2| 4.914000e-04| 2.418800e-03|
|disc_bv      | 0.000000e+00|  3011|  3011|  1700| 6.000000e-07| 1.700000e-06|
|disc_ie      | 0.000000e+00|    31|    31|    12| 3.000000e-07| 1.200000e-06|
|broyden_tri  | 3.970671e-01|   401|   401|   246| 8.000000e-07| 1.800000e-06|
|broyden_band | 0.000000e+00| 11907| 11907| 10000| 7.800000e-05| 3.018000e-04|
|linfun_fr    | 5.500000e+01|     8|     8|     2| 0.000000e+00| 0.000000e+00|
|linfun_r1    | 2.462687e+01|    25|    25|     3| 8.300000e-06| 3.260000e-05|
|linfun_r1z   | 2.612690e+01|    25|    25|     3| 5.400000e-06| 2.120000e-05|
|chebyquad    | 5.386400e-03| 13504| 13504| 10000| 3.366000e-04| 1.074400e-03|

Yowzer. This makes things a lot worse. Worse than steepest descent.

### Preconditioned HS (memory = 5)

|             |            f|    nf|    ng| iter|         ginf|          gr2|
|:------------|------------:|-----:|-----:|----:|------------:|------------:|
|rosen        | 0.000000e+00|    75|    75|   25| 1.000000e-07| 1.000000e-07|
|freud_roth   | 4.898425e+01|    25|    25|   10| 2.000000e-07| 2.000000e-07|
|powell_bs    | 0.000000e+00|   310|   310|   99| 2.000000e-07| 2.000000e-07|
|brown_bs     | 0.000000e+00|    51|    51|   12| 0.000000e+00| 0.000000e+00|
|beale        | 0.000000e+00|    35|    35|   12| 0.000000e+00| 0.000000e+00|
|jenn_samp    | 1.243622e+02|   106|   106|   14| 1.500000e-06| 1.600000e-06|
|helical      | 0.000000e+00|    60|    60|   22| 0.000000e+00| 0.000000e+00|
|bard         | 8.214900e-03|    42|    42|   13| 0.000000e+00| 0.000000e+00|
|gauss        | 0.000000e+00|     6|     6|    2| 4.000000e-07| 5.000000e-07|
|meyer        | 8.794586e+01|   925|   925|  305| 2.082876e+01| 2.082876e+01|
|gulf         | 0.000000e+00|    81|    81|   31| 0.000000e+00| 0.000000e+00|
|box_3d       | 0.000000e+00|    44|    44|   12| 0.000000e+00| 0.000000e+00|
|powell_s     | 0.000000e+00|    72|    72|   29| 4.000000e-07| 4.000000e-07|
|wood         | 0.000000e+00|    54|    54|   20| 0.000000e+00| 0.000000e+00|
|kow_osb      | 3.075000e-04|    37|    37|   14| 0.000000e+00| 1.000000e-07|
|brown_den    | 8.582220e+04|   645|   645|   45| 4.300000e-06| 5.800000e-06|
|osborne_1    | 5.460000e-05|   162|   162|   63| 2.000000e-07| 2.000000e-07|
|biggs_exp6   | 5.655600e-03|    61|    61|   25| 1.000000e-06| 1.600000e-06|
|osborne_2    | 4.013770e-02|   330|   330|  162| 1.000000e-06| 1.300000e-06|
|watson       | 0.000000e+00|   784|   784|  362| 9.000000e-07| 2.100000e-06|
|ex_rosen     | 0.000000e+00|    70|    70|   24| 3.000000e-07| 1.000000e-06|
|ex_powell    | 0.000000e+00|    76|    76|   29| 8.000000e-07| 2.000000e-06|
|penalty_1    | 2.025000e-04| 15342| 15342| 1117| 2.000000e-07| 1.000000e-06|
|penalty_2    | 2.154560e-02|   441|   441|  172| 6.000000e-07| 1.100000e-06|
|var_dim      | 3.058329e+08|    19|    19|    2| 2.775161e+08| 8.994928e+08|
|trigon       | 5.700000e-06|    81|    81|   38| 6.000000e-07| 1.100000e-06|
|brown_al     | 4.000000e-07|    29|    29|    2| 4.914000e-04| 2.418800e-03|
|disc_bv      | 0.000000e+00|  2021|  2021| 1108| 1.000000e-06| 2.700000e-06|
|disc_ie      | 0.000000e+00|    23|    23|    8| 0.000000e+00| 1.000000e-07|
|broyden_tri  | 0.000000e+00|    55|    55|   26| 8.000000e-07| 2.200000e-06|
|broyden_band | 3.054547e+00|   164|   164|   73| 6.000000e-07| 1.800000e-06|
|linfun_fr    | 5.552666e+01|     6|     6|    2| 2.163662e-01| 1.451428e+00|
|linfun_r1    | 2.462687e+01|    23|    23|    3| 6.580000e-05| 2.592000e-04|
|linfun_r1z   | 2.612690e+01|    23|    23|    2| 1.000000e-07| 6.000000e-07|
|chebyquad    | 5.386300e-03|   580|   580|  303| 8.000000e-07| 2.200000e-06|

At least it improves HS.

### Preconditioned HS+ (memory = 5)

|             |            f|   nf|   ng| iter|      ginf|       gr2|
|:------------|------------:|----:|----:|----:|---------:|---------:|
|rosen        | 0.000000e+00|   71|   71|   24| 0.0000002| 0.0000002|
|freud_roth   | 4.898425e+01|   22|   22|    7| 0.0000000| 0.0000000|
|powell_bs    | 0.000000e+00|  306|  306|  102| 0.0000000| 0.0000000|
|brown_bs     | 0.000000e+00|   52|   52|   14| 0.0000000| 0.0000000|
|beale        | 0.000000e+00|   29|   29|   10| 0.0000004| 0.0000005|
|jenn_samp    | 1.243622e+02|   50|   50|   12| 0.0000007| 0.0000010|
|helical      | 0.000000e+00|   63|   63|   23| 0.0000000| 0.0000000|
|bard         | 8.214900e-03|   39|   39|   12| 0.0000000| 0.0000000|
|gauss        | 0.000000e+00|    6|    6|    2| 0.0000004| 0.0000005|
|meyer        | 8.794586e+01|  896|  896|  306| 0.3651832| 0.3651833|
|gulf         | 0.000000e+00|   86|   86|   30| 0.0000000| 0.0000000|
|box_3d       | 0.000000e+00|   45|   45|   17| 0.0000003| 0.0000003|
|powell_s     | 0.000000e+00|   66|   66|   26| 0.0000003| 0.0000005|
|wood         | 0.000000e+00|   55|   55|   18| 0.0000000| 0.0000000|
|kow_osb      | 3.075000e-04|   41|   41|   16| 0.0000001| 0.0000001|
|brown_den    | 8.582220e+04| 6486| 6486|  336| 0.0000295| 0.0000464|
|osborne_1    | 5.460000e-05|  176|  176|   67| 0.0000000| 0.0000001|
|biggs_exp6   | 5.655600e-03|   66|   66|   26| 0.0000005| 0.0000007|
|osborne_2    | 4.013770e-02|  458|  458|  228| 0.0000006| 0.0000009|
|watson       | 0.000000e+00|  922|  922|  420| 0.0000005| 0.0000009|
|ex_rosen     | 0.000000e+00|   71|   71|   24| 0.0000004| 0.0000013|
|ex_powell    | 0.000000e+00|   80|   80|   31| 0.0000003| 0.0000008|
|penalty_1    | 2.025000e-04|  193|  193|   40| 0.0000008| 0.0000035|
|penalty_2    | 2.154560e-02|  485|  485|  178| 0.0000008| 0.0000015|
|var_dim      | 3.200000e-06|   39|   39|    6| 0.1075708| 0.3486613|
|trigon       | 5.700000e-06|   82|   82|   37| 0.0000010| 0.0000023|
|brown_al     | 4.000000e-07|   29|   29|    2| 0.0004914| 0.0024188|
|disc_bv      | 0.000000e+00| 2094| 2094| 1148| 0.0000008| 0.0000020|
|disc_ie      | 0.000000e+00|   21|   21|    7| 0.0000002| 0.0000004|
|broyden_tri  | 0.000000e+00|   55|   55|   26| 0.0000009| 0.0000023|
|broyden_band | 3.054547e+00|  152|  152|   69| 0.0000009| 0.0000016|
|linfun_fr    | 5.500000e+01|    8|    8|    2| 0.0000000| 0.0000000|
|linfun_r1    | 2.462687e+01|   25|   25|    3| 0.0000103| 0.0000404|
|linfun_r1z   | 2.612690e+01|   23|   23|    2| 0.0000007| 0.0000026|
|chebyquad    | 5.386300e-03|  646|  646|  337| 0.0000007| 0.0000024|

Oddly, although preconditions HS+ improved on standard HS+, preconditioned HS 
is a little bit better than preconditioned HS+.

### Preconditioned PR

|             |            f|   nf|   ng| iter|       ginf|        gr2|
|:------------|------------:|----:|----:|----:|----------:|----------:|
|rosen        | 0.000000e+00|   79|   79|   27|  0.0000003|  0.0000003|
|freud_roth   | 4.898425e+01|   32|   32|   11|  0.0000001|  0.0000001|
|powell_bs    | 0.000000e+00|  318|  318|  106|  0.0000002|  0.0000002|
|brown_bs     | 0.000000e+00|   53|   53|   16|  0.0000000|  0.0000000|
|beale        | 0.000000e+00|   33|   33|   10|  0.0000002|  0.0000002|
|jenn_samp    | 1.243622e+02|   43|   43|   11|  0.0000000|  0.0000000|
|helical      | 0.000000e+00|   69|   69|   22|  0.0000003|  0.0000003|
|bard         | 8.214900e-03|   42|   42|   15|  0.0000000|  0.0000000|
|gauss        | 0.000000e+00|    6|    6|    2|  0.0000005|  0.0000006|
|meyer        | 8.794586e+01|  891|  891|  312| 14.5080528| 14.5080531|
|gulf         | 0.000000e+00|   85|   85|   29|  0.0000001|  0.0000001|
|box_3d       | 0.000000e+00|   39|   39|   10|  0.0000001|  0.0000001|
|powell_s     | 0.000000e+00|   69|   69|   26|  0.0000004|  0.0000006|
|wood         | 0.000000e+00|  133|  133|   49|  0.0000000|  0.0000001|
|kow_osb      | 3.075000e-04|   45|   45|   17|  0.0000008|  0.0000008|
|brown_den    | 8.582220e+04|  122|  122|   19|  0.0001448|  0.0001652|
|osborne_1    | 5.460000e-05|  164|  164|   63|  0.0000000|  0.0000000|
|biggs_exp6   | 5.655600e-03|   68|   68|   29|  0.0000000|  0.0000000|
|osborne_2    | 4.013770e-02|  293|  293|  148|  0.0000008|  0.0000011|
|watson       | 0.000000e+00|  768|  768|  345|  0.0000006|  0.0000011|
|ex_rosen     | 0.000000e+00|   68|   68|   23|  0.0000002|  0.0000008|
|ex_powell    | 0.000000e+00|   89|   89|   34|  0.0000004|  0.0000009|
|penalty_1    | 2.025000e-04|  105|  105|   28|  0.0000003|  0.0000015|
|penalty_2    | 2.154560e-02|  564|  564|  217|  0.0000009|  0.0000022|
|var_dim      | 0.000000e+00|   47|   47|    7|  0.0000001|  0.0000004|
|trigon       | 5.700000e-06|   82|   82|   37|  0.0000008|  0.0000020|
|brown_al     | 4.000000e-07|   29|   29|    2|  0.0004914|  0.0024188|
|disc_bv      | 0.000000e+00| 1784| 1784|  974|  0.0000010|  0.0000025|
|disc_ie      | 0.000000e+00|   22|   22|    8|  0.0000001|  0.0000002|
|broyden_tri  | 0.000000e+00|   56|   56|   26|  0.0000006|  0.0000019|
|broyden_band | 0.000000e+00|   46|   46|   15|  0.0000003|  0.0000006|
|linfun_fr    | 5.500000e+01|    8|    8|    2|  0.0000000|  0.0000000|
|linfun_r1    | 2.462687e+01|   25|   25|    3|  0.0000658|  0.0002592|
|linfun_r1z   | 2.612690e+01|   23|   23|    2|  0.0000001|  0.0000006|
|chebyquad    | 5.386300e-03|  601|  601|  317|  0.0000009|  0.0000020|

Preconditioned PR improves on PR.

### Preconditioned PR+ (memory = 5)

|             |            f|   nf|   ng| iter|      ginf|       gr2|
|:------------|------------:|----:|----:|----:|---------:|---------:|
|rosen        | 0.000000e+00|   81|   81|   27| 0.0000000| 0.0000000|
|freud_roth   | 4.898425e+01|   28|   28|    9| 0.0000007| 0.0000007|
|powell_bs    | 0.000000e+00|  311|  311|  101| 0.0000003| 0.0000003|
|brown_bs     | 0.000000e+00|   48|   48|   13| 0.0000000| 0.0000000|
|beale        | 0.000000e+00|   36|   36|   12| 0.0000001| 0.0000001|
|jenn_samp    | 1.243622e+02|   97|   97|   13| 0.0000018| 0.0000025|
|helical      | 0.000000e+00|   68|   68|   21| 0.0000001| 0.0000001|
|bard         | 8.214900e-03|   36|   36|   12| 0.0000000| 0.0000000|
|gauss        | 0.000000e+00|    6|    6|    2| 0.0000005| 0.0000006|
|meyer        | 8.794586e+01|  910|  910|  316| 0.9485863| 0.9485863|
|gulf         | 0.000000e+00|   90|   90|   32| 0.0000001| 0.0000001|
|box_3d       | 0.000000e+00|   43|   43|   16| 0.0000002| 0.0000003|
|powell_s     | 0.000000e+00|   56|   56|   20| 0.0000009| 0.0000009|
|wood         | 0.000000e+00|  139|  139|   50| 0.0000000| 0.0000000|
|kow_osb      | 3.075000e-04|   41|   41|   16| 0.0000004| 0.0000005|
|brown_den    | 8.582220e+04|   42|   42|   14| 0.0000001| 0.0000001|
|osborne_1    | 5.460000e-05|  175|  175|   68| 0.0000000| 0.0000000|
|biggs_exp6   | 5.655600e-03|   69|   69|   28| 0.0000001| 0.0000002|
|osborne_2    | 4.013770e-02|  361|  361|  180| 0.0000003| 0.0000005|
|watson       | 0.000000e+00| 1029| 1029|  469| 0.0000008| 0.0000016|
|ex_rosen     | 0.000000e+00|   79|   79|   27| 0.0000000| 0.0000001|
|ex_powell    | 0.000000e+00|   65|   65|   24| 0.0000001| 0.0000001|
|penalty_1    | 2.025000e-04|   98|   98|   25| 0.0000009| 0.0000043|
|penalty_2    | 2.154560e-02|  449|  449|  169| 0.0000008| 0.0000019|
|var_dim      | 0.000000e+00|   47|   47|    7| 0.0000001| 0.0000004|
|trigon       | 5.700000e-06|   83|   83|   38| 0.0000007| 0.0000015|
|brown_al     | 4.000000e-07|   29|   29|    2| 0.0004914| 0.0024188|
|disc_bv      | 0.000000e+00| 2162| 2162| 1184| 0.0000006| 0.0000019|
|disc_ie      | 0.000000e+00|   21|   21|    7| 0.0000004| 0.0000007|
|broyden_tri  | 0.000000e+00|   55|   55|   26| 0.0000008| 0.0000023|
|broyden_band | 0.000000e+00|   46|   46|   15| 0.0000003| 0.0000006|
|linfun_fr    | 5.500000e+01|    8|    8|    2| 0.0000000| 0.0000000|
|linfun_r1    | 2.462687e+01|   25|   25|    3| 0.0000103| 0.0000404|
|linfun_r1z   | 2.612690e+01|   23|   23|    2| 0.0000007| 0.0000026|
|chebyquad    | 5.386300e-03|  604|  604|  324| 0.0000009| 0.0000023|

Again, the + version of the preconditioned update doesn't seem quite as good as
the normal version. Although the difference isn't as large as with HS and HS+.

Preconditioned HS overall is the best of this group.

### Preconditioned HZ (memory = 5)

|             |            f|   nf|   ng| iter|       ginf|        gr2|
|:------------|------------:|----:|----:|----:|----------:|----------:|
|rosen        | 0.000000e+00|   74|   74|   24|  0.0000006|  0.0000007|
|freud_roth   | 4.898425e+01|   33|   33|   11|  0.0000004|  0.0000004|
|powell_bs    | 0.000000e+00|  299|  299|  105|  0.0000000|  0.0000000|
|brown_bs     | 0.000000e+00|   51|   51|   14|  0.0000007|  0.0000007|
|beale        | 0.000000e+00|   29|   29|   10|  0.0000006|  0.0000006|
|jenn_samp    | 1.243622e+02|   32|   32|    9|  0.0000000|  0.0000001|
|helical      | 0.000000e+00|   59|   59|   21|  0.0000003|  0.0000004|
|bard         | 8.214900e-03|   39|   39|   12|  0.0000006|  0.0000006|
|gauss        | 0.000000e+00|    6|    6|    2|  0.0000004|  0.0000004|
|meyer        | 8.794586e+01|  937|  937|  295| 58.3142594| 58.3142610|
|gulf         | 0.000000e+00|   93|   93|   29|  0.0000009|  0.0000009|
|box_3d       | 0.000000e+00|   53|   53|   18|  0.0000000|  0.0000000|
|powell_s     | 0.000000e+00|   62|   62|   25|  0.0000001|  0.0000001|
|wood         | 0.000000e+00|  179|  179|   64|  0.0000000|  0.0000000|
|kow_osb      | 3.075000e-04|   40|   40|   15|  0.0000007|  0.0000007|
|brown_den    | 8.582220e+04|   48|   48|   16|  0.0000000|  0.0000000|
|osborne_1    | 5.460000e-05|  173|  173|   64|  0.0000007|  0.0000007|
|biggs_exp6   | 5.655600e-03|   66|   66|   27|  0.0000001|  0.0000002|
|osborne_2    | 4.013770e-02|  268|  268|  136|  0.0000007|  0.0000014|
|watson       | 0.000000e+00| 1163| 1163|  533|  0.0000008|  0.0000017|
|ex_rosen     | 0.000000e+00|   74|   74|   22|  0.0000003|  0.0000011|
|ex_powell    | 0.000000e+00|   77|   77|   30|  0.0000005|  0.0000017|
|penalty_1    | 2.025000e-04|  104|  104|   28|  0.0000001|  0.0000004|
|penalty_2    | 2.154560e-02|  611|  611|  225|  0.0000007|  0.0000014|
|var_dim      | 0.000000e+00|   47|   47|    7|  0.0000001|  0.0000004|
|trigon       | 5.700000e-06|   79|   79|   38|  0.0000007|  0.0000023|
|brown_al     | 4.000000e-07|   29|   29|    2|  0.0004914|  0.0024188|
|disc_bv      | 0.000000e+00| 2044| 2044| 1132|  0.0000010|  0.0000027|
|disc_ie      | 0.000000e+00|   21|   21|    7|  0.0000007|  0.0000012|
|broyden_tri  | 0.000000e+00|   57|   57|   27|  0.0000005|  0.0000015|
|broyden_band | 0.000000e+00|   44|   44|   16|  0.0000006|  0.0000010|
|linfun_fr    | 5.500000e+01|    8|    8|    2|  0.0000000|  0.0000000|
|linfun_r1    | 2.462687e+01|   25|   25|    3|  0.0000161|  0.0000632|
|linfun_r1z   | 2.612690e+01|   25|   25|    3|  0.0000021|  0.0000082|
|chebyquad    | 5.386300e-03|  663|  663|  352|  0.0000007|  0.0000021|

### Precondtioned HZ+ (memory = 5)

|             |            f|   nf|   ng| iter|       ginf|        gr2|
|:------------|------------:|----:|----:|----:|----------:|----------:|
|rosen        | 0.000000e+00|   74|   74|   24|  0.0000006|  0.0000007|
|freud_roth   | 4.898425e+01|   33|   33|   11|  0.0000004|  0.0000004|
|powell_bs    | 0.000000e+00|  299|  299|  105|  0.0000000|  0.0000000|
|brown_bs     | 0.000000e+00|   51|   51|   14|  0.0000005|  0.0000005|
|beale        | 0.000000e+00|   29|   29|   10|  0.0000006|  0.0000006|
|jenn_samp    | 1.243622e+02|   38|   38|   10|  0.0000006|  0.0000006|
|helical      | 0.000000e+00|   59|   59|   21|  0.0000003|  0.0000004|
|bard         | 8.214900e-03|   39|   39|   12|  0.0000006|  0.0000006|
|gauss        | 0.000000e+00|    6|    6|    2|  0.0000004|  0.0000004|
|meyer        | 8.794586e+01|  914|  914|  307| 14.3191847| 14.3191850|
|gulf         | 0.000000e+00|   93|   93|   29|  0.0000009|  0.0000009|
|box_3d       | 0.000000e+00|   53|   53|   18|  0.0000000|  0.0000000|
|powell_s     | 0.000000e+00|   62|   62|   25|  0.0000001|  0.0000001|
|wood         | 0.000000e+00|  131|  131|   49|  0.0000000|  0.0000000|
|kow_osb      | 3.075000e-04|   40|   40|   15|  0.0000007|  0.0000007|
|brown_den    | 8.582220e+04|   48|   48|   16|  0.0000000|  0.0000000|
|osborne_1    | 5.460000e-05|  173|  173|   64|  0.0000007|  0.0000007|
|biggs_exp6   | 5.655600e-03|   66|   66|   27|  0.0000001|  0.0000002|
|osborne_2    | 4.013770e-02|  268|  268|  136|  0.0000007|  0.0000014|
|watson       | 0.000000e+00| 1163| 1163|  533|  0.0000008|  0.0000017|
|ex_rosen     | 0.000000e+00|   74|   74|   22|  0.0000003|  0.0000011|
|ex_powell    | 0.000000e+00|   77|   77|   30|  0.0000005|  0.0000017|
|penalty_1    | 2.025000e-04|  104|  104|   28|  0.0000001|  0.0000004|
|penalty_2    | 2.154560e-02|  611|  611|  225|  0.0000007|  0.0000014|
|var_dim      | 0.000000e+00|   47|   47|    7|  0.0000001|  0.0000004|
|trigon       | 5.700000e-06|   79|   79|   38|  0.0000007|  0.0000023|
|brown_al     | 4.000000e-07|   29|   29|    2|  0.0004914|  0.0024188|
|disc_bv      | 0.000000e+00| 2044| 2044| 1132|  0.0000010|  0.0000027|
|disc_ie      | 0.000000e+00|   21|   21|    7|  0.0000007|  0.0000012|
|broyden_tri  | 0.000000e+00|   57|   57|   27|  0.0000005|  0.0000015|
|broyden_band | 0.000000e+00|   41|   41|   15|  0.0000009|  0.0000022|
|linfun_fr    | 5.500000e+01|    8|    8|    2|  0.0000000|  0.0000000|
|linfun_r1    | 2.462687e+01|   25|   25|    3|  0.0000161|  0.0000632|
|linfun_r1z   | 2.612690e+01|   25|   25|    3|  0.0000021|  0.0000082|
|chebyquad    | 5.386300e-03|  663|  663|  352|  0.0000007|  0.0000021|

Preconditioned HZ+ does a little better than HZ. And it's actually quite
competitive with the other results. Only preconditioned HS has a slight edge.

### Preconditioning with memory = 20

```
res_pcg_hzp20 <- benchmark_funco_all(method = "CG", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, max_iter = 10000, cg_update = "HZ+", preconditioner = "L-BFGS", memory = 20)
```

This helps in all cases. Roughly HS does better than PR which does better than
HZ. The effect of the "+" modification is not consistent. But it is fairly
small. However, none of these results outdo just using L-BFGS with memory = 20.

Here's the preconditioned HS result as an illustration:

|             |            f|    nf|    ng| iter|         ginf|          gr2|
|:------------|------------:|-----:|-----:|----:|------------:|------------:|
|rosen        | 0.000000e+00|    75|    75|   25| 1.000000e-07| 1.000000e-07|
|freud_roth   | 4.898425e+01|    25|    25|   10| 2.000000e-07| 2.000000e-07|
|powell_bs    | 0.000000e+00|   310|   310|   99| 2.000000e-07| 2.000000e-07|
|brown_bs     | 0.000000e+00|    51|    51|   12| 0.000000e+00| 0.000000e+00|
|beale        | 0.000000e+00|    35|    35|   12| 0.000000e+00| 0.000000e+00|
|jenn_samp    | 1.243622e+02|   106|   106|   14| 1.500000e-06| 1.600000e-06|
|helical      | 0.000000e+00|    56|    56|   20| 5.000000e-07| 5.000000e-07|
|bard         | 8.214900e-03|    40|    40|   12| 1.000000e-07| 1.000000e-07|
|gauss        | 0.000000e+00|     6|     6|    2| 4.000000e-07| 5.000000e-07|
|meyer        | 8.794586e+01|   873|   873|  301| 2.872756e-01| 2.872756e-01|
|gulf         | 0.000000e+00|    84|    84|   31| 0.000000e+00| 0.000000e+00|
|box_3d       | 0.000000e+00|    44|    44|   12| 0.000000e+00| 0.000000e+00|
|powell_s     | 0.000000e+00|    56|    56|   22| 3.000000e-07| 5.000000e-07|
|wood         | 0.000000e+00|    51|    51|   18| 2.000000e-07| 2.000000e-07|
|kow_osb      | 3.075000e-04|    37|    37|   14| 1.000000e-07| 1.000000e-07|
|brown_den    | 8.582220e+04|    42|    42|   14| 3.000000e-07| 3.000000e-07|
|osborne_1    | 5.460000e-05|   138|   138|   51| 2.000000e-07| 2.000000e-07|
|biggs_exp6   | 5.655600e-03|    58|    58|   23| 6.000000e-07| 9.000000e-07|
|osborne_2    | 4.013770e-02|   119|   119|   51| 4.000000e-07| 6.000000e-07|
|watson       | 0.000000e+00|    84|    84|   34| 6.000000e-07| 1.200000e-06|
|ex_rosen     | 0.000000e+00|    70|    70|   24| 3.000000e-07| 1.000000e-06|
|ex_powell    | 0.000000e+00|    61|    61|   24| 5.000000e-07| 1.200000e-06|
|penalty_1    | 2.025000e-04| 15222| 15222| 1126| 5.000000e-07| 2.200000e-06|
|penalty_2    | 2.154560e-02|   444|   444|  161| 3.000000e-07| 6.000000e-07|
|var_dim      | 3.058329e+08|    19|    19|    2| 2.775161e+08| 8.994928e+08|
|trigon       | 5.700000e-06|    79|    79|   35| 7.000000e-07| 1.500000e-06|
|brown_al     | 4.000000e-07|    29|    29|    2| 4.914000e-04| 2.418800e-03|
|disc_bv      | 0.000000e+00|   880|   880|  472| 1.000000e-06| 3.200000e-06|
|disc_ie      | 0.000000e+00|    23|    23|    8| 0.000000e+00| 0.000000e+00|
|broyden_tri  | 0.000000e+00|    55|    55|   26| 9.000000e-07| 2.100000e-06|
|broyden_band | 3.054547e+00|   118|   118|   52| 3.000000e-07| 9.000000e-07|
|linfun_fr    | 5.552666e+01|     6|     6|    2| 2.163662e-01| 1.451428e+00|
|linfun_r1    | 2.462687e+01|    23|    23|    3| 6.580000e-05| 2.592000e-04|
|linfun_r1z   | 2.612690e+01|    23|    23|    2| 1.000000e-07| 6.000000e-07|
|chebyquad    | 5.386300e-03|   403|   403|  206| 9.000000e-07| 2.500000e-06|

## Line Search

### Safe Cubic

benchmark_funco_all(method = "L-BFGS", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, memory = 20, max_iter = 10000, ls_safe_cubic = TRUE)

|             |            f|  nf|  ng| iter|      ginf|       gr2|
|:------------|------------:|---:|---:|----:|---------:|---------:|
|rosen        | 0.000000e+00|  52|  52|   38| 0.0000000| 0.0000000|
|freud_roth   | 4.898425e+01|  27|  27|   22| 0.0000001| 0.0000001|
|powell_bs    | 0.000000e+00| 203| 203|  159| 0.0000003| 0.0000003|
|brown_bs     | 0.000000e+00|  39|  39|   16| 0.0000001| 0.0000001|
|beale        | 0.000000e+00|  18|  18|   16| 0.0000000| 0.0000000|
|jenn_samp    | 1.243622e+02|  26|  26|   19| 0.0000002| 0.0000003|
|helical      | 0.000000e+00|  39|  39|   29| 0.0000001| 0.0000001|
|bard         | 8.214900e-03|  31|  31|   26| 0.0000001| 0.0000001|
|gauss        | 0.000000e+00|   7|   7|    3| 0.0000000| 0.0000000|
|meyer        | 8.794586e+01| 609| 609|  444| 0.6329286| 0.6329286|
|gulf         | 0.000000e+00|  78|  78|   60| 0.0000001| 0.0000001|
|box_3d       | 0.000000e+00|  44|  44|   34| 0.0000004| 0.0000006|
|powell_s     | 0.000000e+00|  51|  51|   43| 0.0000008| 0.0000012|
|wood         | 0.000000e+00| 121| 121|   93| 0.0000006| 0.0000008|
|kow_osb      | 3.075000e-04|  33|  33|   26| 0.0000007| 0.0000009|
|brown_den    | 8.582220e+04| 435| 435|   44| 0.0000205| 0.0000208|
|osborne_1    | 5.460000e-05| 112| 112|  101| 0.0000009| 0.0000009|
|biggs_exp6   | 5.655600e-03|  51|  51|   46| 0.0000001| 0.0000001|
|osborne_2    | 4.013770e-02|  80|  80|   75| 0.0000004| 0.0000006|
|watson       | 0.000000e+00| 128| 128|  113| 0.0000004| 0.0000010|
|ex_rosen     | 0.000000e+00|  49|  49|   38| 0.0000002| 0.0000006|
|ex_powell    | 0.000000e+00|  44|  44|   38| 0.0000004| 0.0000013|
|penalty_1    | 2.025000e-04|  84|  84|   59| 0.0000005| 0.0000023|
|penalty_2    | 2.154560e-02| 244| 244|  216| 0.0000008| 0.0000018|
|var_dim      | 0.000000e+00|  45|  45|   29| 0.0000001| 0.0000003|
|trigon       | 5.700000e-06|  42|  42|   39| 0.0000006| 0.0000011|
|brown_al     | 0.000000e+00|  35|  35|   26| 0.0000001| 0.0000004|
|disc_bv      | 0.000000e+00| 633| 633|  625| 0.0000007| 0.0000020|
|disc_ie      | 0.000000e+00|  13|  13|   10| 0.0000007| 0.0000025|
|broyden_tri  | 0.000000e+00|  32|  32|   28| 0.0000002| 0.0000007|
|broyden_band | 0.000000e+00|  23|  23|   18| 0.0000005| 0.0000008|
|linfun_fr    | 5.500000e+01|   7|   7|    3| 0.0000000| 0.0000000|
|linfun_r1    | 2.462687e+01|  23|  23|    4| 0.0000000| 0.0000002|
|linfun_r1z   | 2.612690e+01|  23|  23|    4| 0.0000001| 0.0000004|
|chebyquad    | 5.386300e-03| 288| 288|  271| 0.0000009| 0.0000027|

Safe cubic affects only Meyer (albeit positively).

### c2 = 0.1

```
benchmark_funco_all(method = "L-BFGS", abs_tol = 0, rel_tol = 0, step_tol = .Machine$double.eps, grad_tol = 1e-6, ginf_tol = 1e-6, memory = 20, max_iter = 10000, c2 = 0.1)
```

|             |            f|   nf|   ng| iter|       ginf|        gr2|
|:------------|------------:|----:|----:|----:|----------:|----------:|
|rosen        | 0.000000e+00|   69|   69|   25|  0.0000000|  0.0000000|
|freud_roth   | 4.898425e+01|   22|   22|    8|  0.0000001|  0.0000001|
|powell_bs    | 0.000000e+00|  313|  313|   99|  0.0000003|  0.0000003|
|brown_bs     | 0.000000e+00|   41|   41|   13|  0.0000008|  0.0000008|
|beale        | 0.000000e+00|   26|   26|   10|  0.0000001|  0.0000002|
|jenn_samp    | 1.243622e+02|  106|  106|   13|  0.0000075|  0.0000099|
|helical      | 0.000000e+00|   53|   53|   21|  0.0000000|  0.0000000|
|bard         | 8.214900e-03|   32|   32|   12|  0.0000000|  0.0000000|
|gauss        | 0.000000e+00|    7|    7|    2|  0.0000001|  0.0000001|
|meyer        | 8.794586e+01|  890|  890|  281| 66.3215190| 66.3215204|
|gulf         | 0.000000e+00|   82|   82|   29|  0.0000001|  0.0000001|
|box_3d       | 0.000000e+00|   47|   47|   18|  0.0000001|  0.0000001|
|powell_s     | 0.000000e+00|   74|   74|   30|  0.0000001|  0.0000001|
|wood         | 0.000000e+00|   51|   51|   20|  0.0000002|  0.0000002|
|kow_osb      | 3.075000e-04|   36|   36|   15|  0.0000008|  0.0000010|
|brown_den    | 8.582220e+04|   41|   41|   14|  0.0000002|  0.0000002|
|osborne_1    | 5.460000e-05|  140|  140|   51|  0.0000001|  0.0000001|
|biggs_exp6   | 5.655600e-03|   63|   63|   27|  0.0000001|  0.0000002|
|osborne_2    | 4.013770e-02|  112|  112|   52|  0.0000002|  0.0000003|
|watson       | 0.000000e+00|   79|   79|   33|  0.0000003|  0.0000006|
|ex_rosen     | 0.000000e+00|   70|   70|   23|  0.0000000|  0.0000001|
|ex_powell    | 0.000000e+00|   54|   54|   21|  0.0000001|  0.0000002|
|penalty_1    | 2.025000e-04|   91|   91|   24|  0.0000005|  0.0000023|
|penalty_2    | 2.154560e-02|  341|  341|  121|  0.0000005|  0.0000011|
|var_dim      | 0.000000e+00|   36|   36|    8|  0.0000000|  0.0000001|
|trigon       | 5.700000e-06|   74|   74|   34|  0.0000008|  0.0000025|
|brown_al     | 0.000000e+00|   27|   27|    7|  0.0000001|  0.0000008|
|disc_bv      | 0.000000e+00| 1192| 1192|  601|  0.0000009|  0.0000025|
|disc_ie      | 0.000000e+00|   17|   17|    7|  0.0000001|  0.0000002|
|broyden_tri  | 0.000000e+00|   54|   54|   26|  0.0000007|  0.0000023|
|broyden_band | 0.000000e+00|   32|   32|   14|  0.0000002|  0.0000007|
|linfun_fr    | 5.500000e+01|    7|    7|    2|  0.0000000|  0.0000000|
|linfun_r1    | 2.462687e+01|   24|   24|    3|  0.0000001|  0.0000003|
|linfun_r1z   | 2.612690e+01|   24|   24|    3|  0.0000000|  0.0000001|
|chebyquad    | 5.386300e-03|  430|  430|  217|  0.0000010|  0.0000035|

A stronger line search seem to be wasteful in most cases, except for `brown_den`
which reduces the number of gradient evaluations from 435 to 41. It also helps
`watson` although not as much.


