% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_node_navigation.R,
%   R/ctx_node_navigation_cpp.R
\name{parent}
\alias{parent}
\alias{parent.ctx_node}
\alias{parent.ctx_node_cpp}
\title{Find the parent of a node in a context tree}
\usage{
parent(node)

\method{parent}{ctx_node}(node)

\method{parent}{ctx_node_cpp}(node)
}
\arguments{
\item{node}{a \code{ctx_node} object as returned by \code{\link[=find_sequence]{find_sequence()}}}
}
\value{
a \code{ctx_node} object if \code{node} does correspond to the empty
sequence or \code{NULL} when this is not the case
}
\description{
This function returns the parent node of the node represented by the
\code{node} parameter. The result is \code{NULL} if \code{node} is the root node of
its context tree (representing the empty sequence).
}
\details{
Each node of a context tree represents a sequence. When \code{\link[=find_sequence]{find_sequence()}} is
called with success, the returned object represents the corresponding node in
the context tree. Unless the original sequence is empty, this node has a
parent node which is returned as a \code{ctx_node} object by the present function.
Another interpretation is that the function returns the \code{node} object
associated to the sequence obtained by removing the oldest value from the
original sequence.
}
\examples{
dts <- c(0, 1, 1, 1, 0, 0, 1, 0, 1, 0)
dts_ctree <- ctx_tree(dts, min_size = 1, max_depth = 3)
ctx_00 <- find_sequence(dts_ctree, c(0, 0))
## the parent sequence/node corresponds to the 0 context
parent(ctx_00)
identical(parent(ctx_00), find_sequence(dts_ctree, c(0)))
## C++ backend
dts <- c(0, 1, 1, 1, 0, 0, 1, 0, 1, 0)
dts_ctree <- ctx_tree(dts, min_size = 1, max_depth = 3, backend = "C++")
ctx_00 <- find_sequence(dts_ctree, c(0, 0))
## the parent sequence/node corresponds to the 0 context
parent(ctx_00)
identical(parent(ctx_00), find_sequence(dts_ctree, c(0)))
}
