% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_stats.R
\name{print.summary.mixl}
\alias{print.summary.mixl}
\title{Print a model summary}
\usage{
\method{print}{summary.mixl}(x, ...)
}
\arguments{
\item{x}{The summary to print.}

\item{...}{Options to pass to print.}
}
\description{
\code{\link[=print]{print()}} is an S3 method for the summary.mixl class, the output of a model plus goodness of fit metrics
}
\examples{
\donttest{
	data("Train", package="mlogit")
	Train$ID <- Train$id
	Train$CHOICE <- as.numeric(Train$choice)
	    
	mnl_test <- "
	U_A = @B_price * $price_A / 1000 + @B_time * $time_A / 60;
	U_B = @asc + @B_price * $price_B / 1000 + @B_timeB * $time_B / 60;
	"

	model_spec <- mixl::specify_model(mnl_test, Train, disable_multicore=T)

	#only take starting values that are needed
	est <- stats::setNames(c(1, 1,1,1), c("asc", "B_price", "B_time", "B_timeB"))
	availabilities <- mixl::generate_default_availabilities(
		Train, model_spec$num_utility_functions
	)

	model2 <- mixl::estimate(model_spec, est, Train, availabilities = availabilities)
	print(model2)
}
}
