% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_stats.R
\name{print.mixl}
\alias{print.mixl}
\title{Prints the output of a model}
\usage{
\method{print}{mixl}(x, ...)
}
\arguments{
\item{x}{The model to print}

\item{...}{Options to pass to print}
}
\description{
\code{summary} is an S3 method for the smixl class.
It creates a model summary and then prints the result
}
\examples{
\donttest{
	data("Train", package="mlogit")
	Train$ID <- Train$id
	Train$CHOICE <- as.numeric(Train$choice)
	    
	mnl_test <- "
	U_A = @B_price * $price_A / 1000 + @B_time * $time_A / 60;
	U_B = @asc + @B_price * $price_B / 1000 + @B_timeB * $time_B / 60;
	"

	model_spec <- mixl::specify_model(mnl_test, Train)

	#only take starting values that are needed
	est <- stats::setNames(c(1, 1,1,1), c("asc", "B_price", "B_time", "B_timeB"))
	availabilities <- mixl::generate_default_availabilities(
		Train, model_spec$num_utility_functions
	)

	model <- mixl::estimate(model_spec, est, Train, availabilities = availabilities)
	summary(model)
}
}
