% Generated by roxygen2 (4.0.2): do not edit by hand
\name{computeELBO}
\alias{computeELBO}
\title{Compute a lower bound on the log-likelihood (ELBO)}
\usage{
computeELBO(model)
}
\arguments{
\item{model}{a \code{mixedMemModel} object created by the \code{mixedMemModel} constructor}
}
\value{
value of the lower bound on the log-likelihood
}
\description{
Computes the value of a lower bound on the log-likelihood, also called the ELBO, for a mixed membership model.
}
\details{
The lower bound (ELBO) is the objective function in the variational EM algorithim. It is a function of the latent variables (\eqn{\phi} and \eqn{\delta}) and the hyperparameters (\eqn{\alpha} and \eqn{\theta}) and
can be derived by Jensen's inequality.

\eqn{P(obs |\alpha, \theta) \ge E_Q{\log[p(X,Z, \Lambda)]} - E_Q{\log[Q(Z, \Lambda|\phi, \delta)]}}
}

